/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnuhash.h  -  Definition of a hashtable for node management

 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__GNUHASH_H_INCLUDED__)
#define __GNUHASH_H_INCLUDED__

class MGnuNode;

struct key_Value
{
	GUID      Guid;
	DWORD     ID;
	time_t    time;
	key_Value(const GUID& g, DWORD id, time_t t){Guid = g; ID = id; time = t;}
};

#define HASH_SIZE	 10000UL // Size of each hash table
#define REHASH_VALUE	37UL // Offset for rehashing
#define MAX_REHASH		10	 // How many rehashes we try before we consider
							 // the table being too full

class MGnuHash
{
public:
	MGnuHash();
	virtual ~MGnuHash();

	void Insert(const GUID *, DWORD);
	key_Value* FindValue(const GUID *);
	void  ClearUpTable(int nSeconds);

private:
	DWORD CreateKey(const GUID *);
	bool  CompareGuid(const GUID *, const GUID *);
	
	key_Value* m_Table[HASH_SIZE];
	int m_nHashEntries;
	MMutex m_mutex;	
protected:
	MGnuHash(const MGnuHash& rSrc);  // no implementation
};

#endif // __GNUHASH_H_INCLUDED__

