//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: pos.h,v 1.1.1.1 2003/10/29 10:05:00 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __POS_H__
#define __POS_H__

class Xml;
class QString;

//---------------------------------------------------------
//   Pos
//---------------------------------------------------------

class Pos {
   public:
      enum TType { TICKS, SAMPLES, TIME };

   private:
      mutable int sn;

   protected:
      TType _type;
      mutable int    _posTick;
      mutable int    _posSample;
      mutable double _posTime;

   public:
      Pos();
      Pos(const Pos&);
      Pos(int,int,int);
      Pos(int,int,int,int);
      Pos(int, bool ticks=true);
      Pos(const QString&);
      void dump() const;
      void mbt(int*, int*, int*) const;
      void msf(int*, int*, int*, int*) const;

      void invalidSn()  { sn = -1; }

      TType  type() const     { return _type; }
      void   setType(TType t);

      Pos& operator+=(Pos a);
      Pos& operator+=(int a);

      bool operator>(const Pos& s) const {
            return posTick() > s.posTick();
            }
      bool operator<(const Pos& s) const {
            return posTick() < s.posTick();
            }
      bool operator==(const Pos& s) const {
            return posTick() == s.posTick();
            }

      friend Pos operator+(Pos a, Pos b);
      friend Pos operator+(Pos a, int b);

      int    posTick() const;
      int    posSample() const;
      double posTime() const;
      void   setPosTick(int);
      void   setPosSample(int);
      void   setPosTime(double);

      void write(int level, Xml&, const char*) const;
      void read(Xml& xml, const char*);
      bool isValid() const { return true; }
      static bool isValid(int m, int b, int t);
      static bool isValid(int, int, int, int);
      };

//---------------------------------------------------------
//   PosLen
//---------------------------------------------------------

class PosLen : public Pos {
      mutable int    _lenTick;
      mutable int    _lenSample;
      mutable double _lenTime;
      mutable int sn;

   public:
      PosLen();
      PosLen(const PosLen&);
      void dump() const;

      void write(int level, Xml&, const char*) const;
      void read(Xml& xml, const char*);
      void setLenTick(int);
      void setLenSample(int);
      void setLenTime(double);
      int lenTick() const;
      int lenSample() const;
      double lenTime() const;
      Pos end() const;
      int endTick() const    { return end().posTick(); }
      int endSample() const  { return end().posSample(); }
      void setPos(const Pos&);
      };

#endif
