#ifdef HAVE_XMLRPC
#include "motion.h"
#include "conf.h"

#ifdef __freebsd__
#include "video_freebsd.h"
#else
#include "video.h"
#endif /* __freebsd__ */

#include "xmlrpc-httpd.h"

void info(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	xmlrpc_int32 i=0;
	xmlrpc_env env;
	
	while (cnt[i++]);
	i--;

	xmlrpc_env_init(&env);
	
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "(si)", "Motion "VERSION, i));
}

extern config_param config_params[];

void conf_write(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	xmlrpc_env env;
	
	conf_print(cnt);

	xmlrpc_env_init(&env);
	
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
}

void conf_list(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	int j;
	xmlrpc_env env;
	xmlrpc_value *config_struct;
	xmlrpc_value *ret;

	xmlrpc_env_init(&env);

	ret = xmlrpc_build_value (&env, "()");
	for (j=0; config_params[j].param_name != NULL; j++) {
		printf("%d %d %s\n", j, config_params[j].conf_value, config_params[j].param_name);
		if (!config_params[j].conf_value)
			continue;
		config_struct = xmlrpc_build_value (&env, "{s:s,s:s,s:s}", "option", config_params[j].param_name, "type", config_type(&config_params[j]), "help", config_params[j].param_help);
		xmlrpc_array_append_item(&env, ret, config_struct);
	}

	xmlrpc_httpd_result(&env, call, ret);
}

void conf_get(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	int i=0, j=0, thread;
	xmlrpc_env env;
	char *param;
	char *res=NULL;
	int ret=0;
	
	while (cnt[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(is)", &thread, &param);
	printf("conf.get: %d %s\n", thread, param);

	while (config_params[j].param_name != NULL) {
		if (!strcasecmp(param, config_params[j].param_name))
			break;
		j++;
	}

	if (thread>=0 && thread<i && config_params[j].param_name && config_params[j].conf_value) {
		res=config_params[j].print(cnt, NULL, j, thread);
		if (!res)
			res=config_params[j].print(cnt, NULL, j, 0);
	}
	if (!res) {
		res="";
		ret=-1;
	}
	printf("%d %d %d %s\n", i, j, ret, res);
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "(is)", ret, res));
}

void conf_set(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	int i=0, thread;
	xmlrpc_env env;
	char *param, *arg;
	
	while (cnt[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(iss)", &thread, &param, &arg);
	printf("conf.set: %d %s\n", thread, param);

	if (thread>=0 && thread<i) {
		conf_cmdparse(cnt+thread, param, arg);
		xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
	}
}

void action_makemovie(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	int i=0, thread;
	xmlrpc_env env;

	while (cnt[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(i)", &thread);

	if (thread>=0 && thread<i) {
		cnt[thread]->makemovie=1;
	}
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
}

void action_quit(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	xmlrpc_env env;
	int i=0;

	do {
		printf("%d quiting\n", i);
		cnt[i]->makemovie=1;
		cnt[i]->finish=1;
	} while (cnt[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
}

void action_snapshot(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	int i=0, thread;
	xmlrpc_env env;

	while (cnt[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(i)", &thread);

	if (thread>=0 && thread<i) {
		cnt[thread]->snapshot=1;
	}
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
}

void detection_pause(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	int i=0, thread;
	xmlrpc_env env;

	while (cnt[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(i)", &thread);

	if (thread>=0 && thread<i) {
		cnt[thread]->pause=1;
	}
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
}

void detection_resume(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnt=userdata;
	int i=0, thread;
	xmlrpc_env env;

	while (cnt[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(i)", &thread);

	if (thread>=0 && thread<i) {
		cnt[thread]->pause=0;
	}
	xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
}

void track_auto(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnts=userdata;
	struct context *cnt;
	int i=0, thread, active;
	xmlrpc_env env;
	
	while (cnts[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(ii)", &thread, &active);
	printf("track.auto: %d %d\n", thread, active);

	if (thread>=0 && thread<i) {
		cnt=cnts[thread];
		cnt->track.active=active;
		xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
	}
}

void track_pan_move(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnts=userdata;
	struct context *cnt;
	struct coord cent;
	int i=0, thread, pan;
	xmlrpc_env env;
	
	while (cnts[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(ii)", &thread, &pan);
	printf("track.pan: %d %d\n", thread, pan);

	if (thread>=0 && thread<i) {
		cnt=cnts[thread];
		cent.width=cnt->imgs.width;
		cent.height=cnt->imgs.height;
		cent.y=0;
		cent.x=pan;
//		cnt->moved=track_move(cnt, cnt->video_dev, cnt->pipe, cnt->mpipe, &cent, &cnt->imgs, 1);
		track_move(cnt, cnt->video_dev, cnt->pipe, cnt->mpipe, &cent, &cnt->imgs, 1);
		xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
	}
}

void track_tilt_move(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnts=userdata;
	struct context *cnt;
	struct coord cent;
	int i=0, thread, tilt;
	xmlrpc_env env;
	
	while (cnts[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(ii)", &thread, &tilt);
	printf("track.tilt: %d %d\n", thread, tilt);

	if (thread>=0 && thread<i) {
		cnt=cnts[thread];
		cent.width=cnt->imgs.width;
		cent.height=cnt->imgs.height;
		cent.x=0;
		cent.y=tilt;
//		cnt->moved=track_move(cnt, cnt->video_dev, cnt->pipe, cnt->mpipe, &cent, &cnt->imgs, 1);
		track_move(cnt, cnt->video_dev, cnt->pipe, cnt->mpipe, &cent, &cnt->imgs, 1);
		xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
	}
}

void track_set(struct xmlrpc_httpd_call *call, xmlrpc_value *param_array, void *userdata)
{
	struct context **cnts=userdata;
	struct context *cnt;
	int i=0, thread, pan, tilt;
	xmlrpc_env env;
	
	while (cnts[++i]);

	xmlrpc_env_init(&env);
	xmlrpc_parse_value(&env, param_array, "(iii)", &thread, &pan, &tilt);
	printf("track.set: %d %d %d\n", thread, pan, tilt);

	if (thread>=0 && thread<i) {
		cnt=cnts[thread];
//		cnt->moved=track_center(cnt, cnt->video_dev, 1, pan, tilt);
		track_center(cnt, cnt->video_dev, 1, pan, tilt);
		xmlrpc_httpd_result(&env, call, xmlrpc_build_value(&env, "()"));
	}
}

void *motion_control(void *arg)
{
	struct context **cnt=arg;
	
	xmlrpc_httpd_method_add("motion.info", info, (void *)cnt);
	xmlrpc_httpd_method_add("motion.conf.list", conf_list, (void *)cnt);
	xmlrpc_httpd_method_add("motion.conf.get", conf_get, (void *)cnt);
	xmlrpc_httpd_method_add("motion.conf.set", conf_set, (void *)cnt);
	xmlrpc_httpd_method_add("motion.conf.write", conf_write, (void *)cnt);
	xmlrpc_httpd_method_add("motion.action.makemovie", action_makemovie, (void *)cnt);
	xmlrpc_httpd_method_add("motion.action.snapshot", action_snapshot, (void *)cnt);
	xmlrpc_httpd_method_add("motion.action.quit", action_quit, (void *)cnt);
	xmlrpc_httpd_method_add("motion.detection.pause", detection_pause, (void *)cnt);
	xmlrpc_httpd_method_add("motion.detection.resume", detection_resume, (void *)cnt);
	xmlrpc_httpd_method_add("motion.track.auto", track_auto, (void *)cnt);
	xmlrpc_httpd_method_add("motion.track.pan", track_pan_move, (void *)cnt);
	xmlrpc_httpd_method_add("motion.track.tilt", track_tilt_move, (void *)cnt);
	xmlrpc_httpd_method_add("motion.track.set", track_set, (void *)cnt);

	xmlrpc_httpd_run(cnt[0]);
	return 0;
}

#endif /* HAVE_XMLRPC */

