/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.1 2003/05/30 21:41:10 miham Exp $
*/
#ifndef _PROCESSOR_PLUGIN_CONFIG_H_
#define _PROCESSOR_PLUGIN_CONFIG_H_

#include <stdio.h>
#include <pcre.h>

#include "mlist.h"

typedef struct {
	int	debug_resolver;

	/* For destination ports which we need extra statistics */
	mlist	*watched_dports;

	/* For source hosts which we need extra statistics */
	mlist	*watched_shosts;

	/* For setting post-portscan checking .. */
	int	check_portscan;
	char	*cps_int;
} config_processor;

int mplugins_processor_ippl_insert_record(mconfig *ext_conf, mlist *state_list, mlogrec *record);

#endif
