<?php
// $Horde: mnemo/lib/api.php,v 1.2.2.3 2002/12/28 22:54:10 jan Exp $
/*
 * Mnemo external API interface.
 *
 * This file defines Mnemo's external API interface.  Other applications can
 * interact with Mnemo through this API.
 */

/*
 * XXX: Ideally, we'd include base.php to satisfy our dependencies, but that
 * seems to cause a lot of problems with redefinitions and conflicts.  We'll
 * have to sort all of that out later on.
 */

// Find the base file paths for Horde and Mnemo
@define('MNEMO_BASE', dirname(__FILE__) . '/..');

// Include the necessary libraries.
require_once MNEMO_BASE . '/lib/base.php';

function mnemoListMemos($sortby = null, $sortdir = null)
{
    global $conf, $prefs;

    if (!isset($conf['storage']['driver']) ||
        !isset($conf['storage']['params'])) {
        return PEAR::raiseError('Not configured');
    }

    if (!isset($sortby)) $sortby = $prefs->getValue('sortby');
    if (!isset($sortdir)) $sortdir = $prefs->getValue('sortdir');

    /* Create a Mnemo storage instance. */
    require_once MNEMO_BASE . '/lib/Driver.php';
    $storage = &Mnemo_Driver::singleton($conf['storage']['driver'],
                                        Auth::getAuth(), $conf['storage']['params']);
    $storage->retrieve();

    return Mnemo::listMemos($storage, MEMO_ANY, $sortby, $sortdir);
}

function mnemoAddMemo($body = '', $category = '')
{
    global $conf;

    /* Create a Mnemo_Driver instance. */
    require_once MNEMO_BASE . '/lib/Driver.php';
    $storage = &Mnemo_Driver::singleton($conf['storage']['driver'],
                                        Auth::getAuth(), $conf['storage']['params']);
    $storage->retrieve();

    /* Add the new memo. */
    $result = $storage->addMemo($body, $category);
    if ($result >= 0) {
        $result = $storage->store();
    }

    return $result;
}

function mnemoSummary()
{
    global $registry, $prefs, $conf;

    if (!isset($conf['storage']['driver']) ||
        !isset($conf['storage']['params'])) {
        return PEAR::raiseError('Not configured');
    }

    $html  = '<table border="0" cellpadding="2" cellspacing="0" width="100%"><tr><td class="header">';
    $html .= Horde::link(Horde::url($registry->getInitialPage()), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
    $html .= Horde::link(Horde::applicationUrl('memo.php?actionID=' . MNEMO_ADD_MEMO), _("New Note"), 'smallheader') . Horde::img('mnemo.gif', 'alt="' . _("New Note") . '"') . _("New Note") . '</a>';

    $html .= '</td></tr><tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';

    $colors = Mnemo::categoryColors();

    $memos = mnemoListMemos();
    foreach ($memos as $id => $memo) {
        $html .= '  <tr>';

        if ($prefs->getValue('summary_show_colors')) {
            $color = isset($colors[$memo['category']]) ? $colors[$memo['category']] : '#ffffff';
            $priority_cell = '<td width="20" align="center" style="background-color:' . $color . '">&nbsp;&nbsp;&nbsp;</td>';
            $spacer_cell = '<td width="3">&nbsp;</td>';
            $html .= $priority_cell . $spacer_cell;
        }

        $html .= '<td class="text">';
        $html .= Horde::link(Horde::applicationUrl('view.php?memo=' . $id), $memo['desc']) . htmlspecialchars($memo['desc']) . '</a>';
        $html .= "</td></tr>\n";
    }
    $html .= '</table></td></tr></table>';

    return $html;
}

?>
