/*
** libMird by Mirar <mirar@mirar.org>
** please submit bug reports and patches to the author
**
** also see http://www.mirar.org/mird/
**
** for licence, read the LICENCE file
**
** $Id: test.c,v 1.30 2001/08/09 17:33:15 mirar Exp $
**
*/ 
#include <stdio.h>
#include <stdlib.h>

#include "mird.h"

void err(char *when,MIRD_RES res)
{
   mird_perror(when,res);
   mird_free_error(res);
   exit(1);
}

#define TRY(S,X) do { MIRD_RES res; if ( (res=(X)) ) err(S,res); } while (0)
#define WARN(S,X) do { MIRD_RES res; if ( (res=(X)) ) { mird_perror(S,res); mird_free_error(res); } } while (0)

#define Z 9

int main()
{
   struct mird *db;

   TRY("init",mird_initialize("1-file95.mird",&db));
   db->flags|=MIRD_READONLY;
   TRY("open",mird_open(db));

   return 0;
}
