/*
smtp.h - MessageWall SMTP declarations
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _SMTP_H
#define _SMTP_H

#include "messagewall.h"

#define SMTP_LINE_MAXLEN 512
#define SMTP_DOMAIN_MAXLEN 255
#define SMTP_PATH_MAXLEN 256
#define SMTP_WARNING_MAXLEN 256
#define SMTP_MAX_WARNINGS 15

int smtp_parseline(int client);
int smtp_parsedata(int client);
int smtp_handle_line(int client, struct firestring_estr_t *line);
int smtp_get_backend();
int smtp_reject(int client, const char *facility, const char *logmessage, const char *clientmessage, int score, int hard, void *var1, void *var2);
int smtp_error(int client);

int smtp_checks_gotDATA(int client);
int smtp_checks_gotmessage(int client);
int smtp_checks_gotRMX(int client, int timedout);
int smtp_checks_gotDNSBL_DOMAIN(int client);
int smtp_checks_gotRDNS(int client, int timedout);
int smtp_checks_gotDNSBL(int client);
int smtp_checks_gotDNSDCC(int client);
int smtp_start_send(int client);
int smtp_clear(int client);
int smtp_message_clear(int client);

#define SMTP_OK "250 MessageWall: OK\r\n"
#define SMTP_OOO "503 MessageWall: SMTP: Commands out of order\r\n"
#define SMTP_BADCHAR "501 MessageWall: SMTP: Invalid character in path\r\n"
#define SMTP_MAXRCPT "550 MessageWall: SMTP/REJECT: Too many recipients\r\n"
#define SMTP_ONLYONE "452 MessageWall: SMTP/TEMPORARY: One recipient per message from external hosts, please\r\n"
#define SMTP_NORELAY "550 MessageWall: SMTP/REJECT: Relaying denied to '%e'\r\n"
#define SMTP_START_DATA "354 MessageWall: Go ahead\r\n"
#define SMTP_TOOLONG "500 MessageWall: SMTP/FATAL: Line longer than allowed by SMTP specification\r\n"
#define SMTP_MESSAGE_TOOLONG "552 MessageWall: SMTP/FATAL: Message too long\r\n"
#define SMTP_VRFY "252 MessageWall: SMTP/STATUS: We don't do VRFY\r\n"
#define SMTP_REFUSED "552 MessageWall: BACKEND/REJECT: Server refused message\r\n"
#define SMTP_REFUSED_TEMP "451 MessageWall: BACKEND/REJECT: Server temporarily refused message\r\n"
#define SMTP_BACKEND_BROKEN "451 MessageWall: BACKEND/TEMPORARY: Server went away\r\n"
#define SMTP_TIMEOUT "421 MessageWall: SMTP/FATAL: Idle time exceeded\r\n"
#define SMTP_BADMIME "552 MessageWall: MIME/REJECT: Invalid structure\r\n"
#define SMTP_LF "501 MessageWall: SMTP/FATAL: Server sent a bare LF; please see http://cr.yp.to/docs/smtplf.html\r\n"
#define SMTP_7BIT "501 MessageWall: SMTP/FATAL: Server sent an 8bit character to a 7bit server\r\n"
#define SMTP_TO_CC "552 MessageWall: RFC822/REJECT: %e: Target address must be in To or CC headers\r\n"
#define SMTP_FROM "552 MessageWall: RFC822/REJECT: %e: Source address must be in From header\r\n"
#define SMTP_REALNAME "552 MessageWall: RFC822/REJECT: From address must contain a real name\r\n"
#define SMTP_HEADER "552 MessageWall: RFC822/REJECT: Message contained banned header fields: %e%e\r\n"
#define SMTP_ERRORS "554 MessageWall: SMTP/REJECT: Too many errors, goodbye\r\n"
#define SMTP_REJECT "552 MessageWall: SMTP/REJECT: This address does not accept mail\r\n"
#define SMTP_ATTACHMENT "552 MessageWall: MIME/REJECT: Message has an attachment with a filename not accepted at this address ('%e' contains '%e')\r\n"
#define SMTP_USELESS "552 MessageWall: MIME/REJECT: Message contains no parts accepted at this address\r\n"
#define SMTP_MIMEREJECT "552 MessageWall: MIME: Message contains a MIME part not accepted at this address: %e\r\n"
#define SMTP_NO_BACKEND "451 MessageWall: BACKEND/TEMPORARY: No backend currently available\r\n"
#define SMTP_DNSBL "552 MessageWall: DNSBL/REJECT: %e/%s: Your mail server is listed by a DNS-based blacklist.  Please see http://openrbl.org/\r\n"
#define SMTP_DNSBLDOMAIN "552 MessageWall: DNSBL-DOMAIN/REJECT: %e/%e: Your domain is listed by a DNS-based blacklist.  Please see http://rfc-ignorant.org/\r\n"
#define SMTP_DNSDCC "552 MessageWall: DNSDCC/REJECT: %e: One or more parts of your message are listed in a DNS-based distributed checksum system\r\n"
#define SMTP_INVALIDPATH "552 MessageWall: SMTP/REJECT: Invalid forward or reverse path\r\n"
#define SMTP_MIMEPARTS "552 MessageWall: MIME/REJECT: Too many parts\r\n"
#define SMTP_MIMEDEEP "552 MessageWall: MIME/REJECT: Excessive depth\r\n"
#define SMTP_RDNS "552 MessageWall: RDNS/REJECT: %s: Your IP address has no reverse DNS\r\n"
#define SMTP_RMX "552 MessageWall: RMX/REJECT: %e: Your reverse path domain has no MX or A records (reply mail would be undeliverable)\r\n"
#define SMTP_RDNS_TEMP "451 MessageWall: RDNS/REJECT %s: Attempts to look up your IP address's reverse DNS timed out\r\n"
#define SMTP_RMX_TEMP "451 MessageWall: RDNS/REJECT %e: Attempts to look up MX or A records for your reverse path domain timed out\r\n"
#define SMTP_BADBODY "552 MessageWall: MIME/REJECT: body part contains disallowed string: %e\r\n"
#define SMTP_VIRUS "552 MessageWall: VIRUS/REJECT: body part seems to contain the '%e' virus\r\n"

#define SMTP_AUTH_LOGIN_USER "334 VXNlcm5hbWU6\r\n"
#define SMTP_AUTH_LOGIN_PASS "334 UGFzc3dvcmQ6\r\n"
#define SMTP_AUTH_PLAIN "334 MessageWall: Go ahead\r\n"
#define SMTP_AUTH_SUCCEED "235 MessageWall: You may now relay\r\n"
#define SMTP_AUTH_FAIL "535 MessageWall: Invalid credentials; authentication failed\r\n"
#define SMTP_AUTH_BADFORMAT "501 MessageWall: Invalid authentication format\r\n"

#define SMTP_TLS_OK "220 MessageWall: Ready for TLS\r\n"
#define SMTP_TLS_ERROR "454 MessageWall: TLS initialization failed\r\n"

#endif
