/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * $Id: binary.h,v 1.2 2003/02/05 04:38:37 kos Exp $
 *
 */

#ifndef _BINARY_H
#define _BINARY_H

#include "keyspace.h"
#include "generator.h"

#define BIN_DEFLEN 8
#define BIN_LINELEN 1024

typedef struct binary_t {
  int len;
  int minlen;
  int maxlen;  
  key_index_t temp;
  key_index_t index;
  key_index_t minindex;
  key_index_t maxindex;
  key_index_t cur_min;
  key_index_t cur_max;
  key_index_t divisor;
} binary_t;

binary_t *binary_init(char *params);
int binary_set(binary_t *, key_index_t index);
int binary_fetch(binary_t *, kchar *buf, int len, int *rlen);
int binary_done(binary_t *);
int binary_destroy(binary_t *);
key_index_t *binary_minindex(binary_t *);
key_index_t *binary_maxindex(binary_t *);
key_index_t *binary_curindex(binary_t *);
int binary_minlen(binary_t *);
int binary_maxlen(binary_t *);

#endif /* _BINARY_H */
