#!/devtool/local/bin/perl

my $motd_msg =
  "###############################################################\n"
. "# BENCHMARKS ARE RUNNING - PLEASE DO NOT WORK ON THIS MACHINE #\n"
. "#  Currently, a benchmark is running on this machine. Please  #\n"
. "#  log out and try not to create any load on this machine     #\n"
. "#  except you REALLY know what you are doing. Please refer to #\n"
. "#  the testmonitor to see the currently running benchmarks.   #\n"
. "#  If you have any more questions ask falko.flessner\@sap.com  #\n"
. "###############################################################\n";

&motd_remove();
&motd_addmsg($motd_msg);

$| = 1; # Nur zur Sicherheit, damit das (unntige) Buffering ausgeschaltet wird.

if ($^O =~ /MSWin32/i) {
    require File::DosGlob ;
    import  File::DosGlob 'glob';
    require WinLink;
    import  WinLink;
    require Win32::TieRegistry;
    import  Win32::TieRegistry;
    require Win32::Process;
    import  Win32::Process;
    system("NET USE L: \\\\pwdfm017\\LC_POOL");
}

use Sys::Hostname;
use testdb;
my $hostname    = hostname();

if ($ARGV[0] =~ /h/) {
    print "Syntax $PROGRAM_NAME VersionStatus\n";
    print "e.g. $PROGRAM_NAME 7403DEV\n";
    &motd_remove();
    exit(1);
}

my $version = $ARGV[0];
my $tdb;

if ($version =~ /^\d{4}(DEV|COR|RAMP)$/i) {
        $tdb = testdb->new({'version' => substr($version, 0, 4), 'status' => substr($version, 4, 10), 'profile' => 'workday'});
        if ($tdb->{error_code}) {
            testdb::throw_err ($tdb->{error_text});
        }
}

$tdb->preClean();
$tdb->installLC();
$tdb->installTF();

if ($ARGV[1] =~ /.s/) {
	$tdb->run_single_test(" -c tp2_76.cfg tp2_sqldbc_reference.seq");
} 
elsif ($ARGV[1] =~ /.i/)
{
    $tdb->run_single_test(" -c tp2_76.cfg tp2_sqldbc_reference.seq");
	$tdb->run_single_test(" -c tp2_reference_74.cfg tp2_reference.seq");
}
else 
{
	$tdb->run_single_test(" -c tp2_reference_74.cfg tp2_reference.seq");
	$tdb->run_single_test(" -c lvcBench_reference_74.cfg lvcBench_reference.seq");
}

&motd_remove();

sub motd_addmsg {
    my $msg = shift;
    my $motd_path = "/etc/motd";
    if (not (defined $msg)) {
        -1;
        return;
    }

    open (MOFH, ">>$motd_path") or return;

    $msg =~ s/^/TP2: /gm;
    print MOFH $msg;

    close (MOFH);
    return;
}

sub motd_remove {
    my $motd_path = "/etc/motd";
    my $iobuf;

    open (MOFH, $motd_path) or return;

    while (<MOFH>) {
        if (not /^TP2: /) {
            $iobuf .= $_;
        }
    }

    close MOFH;
    open (MOFH, ">$motd_path") or return;

    print MOFH $iobuf;
    close MOFH;
}

