#!/devtool/local/bin/perl
#
# Create a new chr and install the db software in it.
#

BEGIN {
    if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
    }
}

use Sys::Hostname;
use testdbchr;
my $hostname    = hostname();

$| = 1;

my $tdb;
	
use Getopt::Long;
my %options = ();
if ($#ARGV == 0) {
	
	my $version = $ARGV[0];
	
	if ($version =~ /^\d{4}(DEV|COR|RAMP|HOT)$/i) {
		$tdb = testdbchr->new({'version' => substr($version, 0, 4), 'status' => substr($version, 4, 10), 'profile' => 'workday'});
		if ($tdb->{error_code}) {
			testdb::throw_err ($tdb->{error_text});
		}
	}

} else {

	if (! &GetOptions(  \%options,
			'h|help|?',
			'package=s',
			'packid=i',
			'no_objstat',
			'dir=s'
		)) {
		print("Run testdb.pl -h for help");
		exit(1);
	}
	
	if ($options{'dir'}) {
		$options{'dir'} = ($options{'dir'} =~ /^0.*/ ? $options{'dir'} : "0$options{'dir'}");
	}
	
	if ($options{'dir'} && $options{'package'}) {
		my $version = $options{'package'};
		
		if ($version =~ /^\d{4}(DEV|COR|RAMP|HOT)$/i) {
			$tdb = testdbchr->new({'version' => substr($version, 0, 4), 'status' => substr($version, 4, 10), 'profile' => 'workday', 'DIR' => $options{'dir'}, 'no_objstat' => ($options{'no_objstat'} ? 1 : 0)}, {'SESSION_TYPE' => 'TBS'});
			if ($tdb->{error_code}) {
				testdbchr::throw_err ($tdb->{error_text});
			}
		}
	} elsif ($options{'package'}) {
		my $version = $options{'package'};
		
		if ($version =~ /^\d{4}(DEV|COR|RAMP|HOT)$/i) {
			$tdb = testdbchr->new({'version' => substr($version, 0, 4), 'status' => substr($version, 4, 10), 'profile' => 'workday', 'no_objstat' => ($options{'no_objstat'} ? 1 : 0)}, {'SESSION_TYPE' => 'TBS'});
			if ($tdb->{error_code}) {
				testdbchr::throw_err ($tdb->{error_text});
			}
		}
	} elsif ($options{'packid'} && $options{'dir'}) {
		$tdb =  testdbchr->new({'ID' => $options{'packid'}, 'profile' => 'workday', 'DIR' => $options{'dir'}, 'no_objstat' => ($options{'no_objstat'} ? 1 : 0)}, {'SESSION_TYPE' => 'TBS'});
		if ($tdb->{error_code}) {
			testdbchr::throw_err ($tdb->{error_text});
		}
	} elsif ($options{'packid'}) {
		$tdb =  testdbchr->new({'ID' => $options{'packid'}, 'profile' => 'workday', 'no_objstat' => ($options{'no_objstat'} ? 1 : 0)}, {'SESSION_TYPE' => 'TBS'});
		if ($tdb->{error_code}) {
			testdbchr::throw_err ($tdb->{error_text});
		}
	} else {
		print "Please give me a -package wheren giving me a -dir. I don't want to test, I want to install.\n";
		exit (1);
	}
}

$tdb->verify_chr();
$tdb->create_chr();
if ($tdb->jump_in_chr()) {
	$tdb->installLC();
	$tdb->installTF();
} else {
	print "Cound't jump in chr! Exiting...\n";
	exit(1);
}

print "Installation done. Exiting...\n";
exit(0);

