/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "mas/mas.h"
#include "mas/mas_core.h"

int main(int argc, char* argv[])
{
    int32 err;
    struct mas_data_characteristic* dc;
    mas_device_t anx, mix;
    
    masc_log_verbosity( MAS_VERBLVL_DEBUG );

    masc_log_message( 0, "MAS Loopback" );
    masc_log_message( 0, "Loops recorded audio back to the mixer for playback.");
    masc_log_message( 0, "To avoid feedback problems: start with a low playback volume setting.");
    masc_log_message( 0, "" );
    
    err = mas_init();
    if (err < 0)
    {
	printf("\nconnection with server failed.\n");
	exit(1);
    }

    /** get the display-side anx device - we need the mic output */
    err = mas_asm_get_device_by_name( "anx", &anx );
    if ( err < 0 ) masc_logerror( err, "get anx" );

    /** get the display-side mix device */
    err = mas_asm_get_device_by_name( "mix", &mix );
    if ( err < 0 ) masc_logerror( err, "get mix" );

    err = mas_asm_connect_devices( anx, mix, "audio_source", "default_mix_sink" );
    if ( err < 0 ) masc_logerror( err, "Couldn't connect anx output to mixer input" );

    /* start recording */
    err = mas_anx_record_start( anx );
    if ( err < 0 ) masc_logerror( err, "can't start recording" );
    masc_log_message( 0, "Mic is ON" );

    masc_log_message( 0, "Press enter to stop." );
    getchar();
    err = mas_anx_record_stop( anx );
    if ( err < 0 ) masc_logerror( err, "can't stop recording" );
    masc_log_message( 0, "Mic is OFF" );

    sleep(1);

    exit(0);
}
