/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

 /* $Id: mas_ppm.c,v 1.3 2003/10/07 14:31:02 silvio Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mas/mas_api_internal.h"
#include "mas_ppm.h"

#define DEFAULT_PACKAGE_SIZE 1024

/** LOCAL PROTOTYPES *****************************************************/


/** EXPORTED FUNCTIONS ***************************************************/

int32
mas_ppm_set_properties( mas_device_t device, struct ppm_properties *prop )
{
    struct mas_event   event;
    struct mas_package predpack;
    char buffer[1024];

    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_ppm_set_properties";
    event.device_instance = device->device_instance;

    /* stuff the predicate package */
    masc_setup_package( &predpack, buffer, sizeof buffer, MASC_PACKAGE_STATIC );

    masc_push_uint32( &predpack, prop->integration_ms );
    masc_push_uint32( &predpack, prop->refresh_client );
    masc_push_double( &predpack, prop->decay_time );
    masc_push_double( &predpack, prop->db_cutoff );
    
    masc_finalize_package( &predpack );
    event.predicate = predpack.contents;
    event.predicate_length = predpack.size;
    
    /* send it to the server */
    mas_send_event( &event, device->control_channel );
    masc_strike_package( &predpack );

    return 0;
}


int32
mas_ppm_get_properties( mas_device_t device, struct ppm_properties *prop )
{
    struct mas_event   event;
    struct mas_package rpkg;
    int32 err;

    masc_setup_event( &event );
    event.action_name = "mas_ppm_get_properties";
    event.device_instance = device->device_instance;

    /* send it to the server */
    mas_send_event( &event, device->control_channel );

    /* wait for the reply, then form into package */
    err = mas_recv_package( device->control_channel, &rpkg );
    if ( err < 0 ) return err;

    masc_pull_uint32( &rpkg, &prop->integration_ms );
    masc_pull_uint32( &rpkg, &prop->refresh_client );
    masc_pull_double( &rpkg, &prop->decay_time );
    masc_pull_double( &rpkg, &prop->db_cutoff );  

    masc_strike_package( &rpkg );
    
    return err;
}


/** LOCAL FUNCTIONS ******************************************************/
