// Interface to the singly-linked slist template -*- c++ -*-

/** @file s_list.h
 * Dummy singly-linked list template
 */

/* Copyright  1999-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

#ifndef SLIST
# define SLIST

# ifdef __GNUC__
#  if __GNUC__ < 3
#   include <slist>
#  else
#   include <ext/slist>
#   if __GNUC_MINOR__ == 0
#    define slist std::slist
#   else
#    define slist __gnu_cxx::slist
#   endif // __GNUC_MINOR__ == 0
#  endif // __GNUC__ < 3
# elif defined __sgi
#  include <slist>
#  define slist std::slist
# else // fall back to <list>
# include <list>

/** Dummy singly-linked list template */
template <class T>
class slist
{
public:
  typedef T value_type;
  typedef value_type* pointer;
  typedef const value_type* const_pointer;
  typedef value_type& reference;
  typedef const value_type& const_reference;
  typedef size_t size_type;

private:
  typedef typename std::list<value_type> List;
  List myList;
public:
  slist () : myList () {}
  ~slist () {}

  size_type size () const { return myList.size (); }
  bool empty () const { return myList.empty (); }

  typedef typename List::iterator iterator;
  typedef typename List::const_iterator const_iterator;

  iterator begin () { return myList.begin (); }
  const_iterator begin () const { return myList.begin (); }
  iterator end () { return myList.end (); }
  const_iterator end () const { return myList.end (); }

  iterator insert (iterator pos, const value_type& x) {
    return myList.insert (pos, x);
  }

  iterator insert_after (iterator pos, const value_type& x) {
    if (pos != end ()) pos++;
    return myList.insert (pos, x);
  }

  iterator erase (iterator pos) {
    return myList.erase (pos);
  }

  iterator erase_after (iterator pos) {
    if (pos != end ()) pos++;
    return myList.erase (pos);
  }

  const value_type& front () const { return myList.front (); }
  value_type& front () { return myList.front (); }
  void pop_front () { myList.pop_front (); }
  void push_front (const value_type& x) { myList.push_front (x); }

  void clear () { myList.clear (); }
};
# endif
#endif // SLIST
