// Substitution (expression distribution for variables) -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "Substitution.h"
#include "Expression.h"
#include "VariableDefinition.h"

/** @file Substitution.C
 * Map from variables (quantifiers or function parameters) to expressions
 */

/* Copyright  1999-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

Substitution::Substitution () :
  myExprs ()
{
}

Substitution::~Substitution ()
{
  for (iterator i = myExprs.begin (); i != myExprs.end (); i++)
    i->second->destroy ();
}

class Expression*
Substitution::getExpr (const class VariableDefinition& var)
{
  const_iterator i = myExprs.find (&var);
  return i == myExprs.end () ? NULL : i->second->copy ();
}

void
Substitution::setExpr (const class VariableDefinition& var,
		       class Expression& expr)
{
  assert (expr.isAssignable (var.getType ()));
#ifndef NDEBUG
  std::pair<iterator,bool> status =
#endif // !NDEBUG
    myExprs.insert (Map::value_type (&var, &expr));
  assert (status.second); // must be new mapping
  // substitute the variable in existing substitutions
 again:
  for (iterator i = myExprs.begin (); i != myExprs.end (); i++) {
    class Expression* e = i->second->substitute (*this);
    assert (!!e);
    i->second->destroy ();
    if (i->second != e) {
      i->second = e;
      goto again;
    }
  }
}
