/**********************************************************************

wn_trans_problem(&code,&objective,&result,
                 cost_mat,
                 i_capacities,j_capacities)

**********************************************************************/

#include "wnlib.h"
#include "wnsmat.h"



wn_trans_problem(pcode,pobjective,presult,
                 cost_mat,
                 i_capacities,j_capacities)

int *pcode;
double *pobjective;
wn_sparse_matrix *presult,cost_mat;
double i_capacities[],j_capacities[];

{
  wn_sparse_matrix feasible_result;
  wn_memgp top_group;
  double delta;

  top_group = wn_curgp();
  wn_gpmake("no_free");

  wn_trans_problem_feasible(pcode,&feasible_result,
                            cost_mat,
                            i_capacities,j_capacities);

  if(*pcode == WN_SUBOPTIMAL)
  {
     wn_gppush(top_group);

     wn_trans_problem_simplex_improve(pcode,pobjective,&delta,
                                      presult,feasible_result,
                                      cost_mat,
                                      WN_IHUGE);

     wn_assert(*pcode == WN_SUCCESS);
                        
     wn_gppop();
  }
  else
  {
    *pobjective = WN_FHUGE;
  }

  wn_gpfree();
}



