#!/do/not/sh
# toc_run_description = checking whether to use Qt
# toc_begin_help =
# This test does not actually check for qt - it checks
# to see whether running the qt test is desired, then
# runs that test if it thinks it should. All arguments
# are passed on to the qt test (if it is run), so
# see that test for information on what arguments
# are required.
#
# If --without-qt is used then this test does not check for qt and
# returns zero.
#
# The qt test is invoked in any of the following cases:
#
#   --with-qt is not zero
#
#   --with-QTDIR=/path/to/qt
#
#   --with-QTDIR  and ${QTDIR} points to /path/to/qt
#
# Sets these config vars:
#
# - HAVE_QT: zero or one
#
# Others will be set by the qt test if it is run.
#
# Returns one of:
#
#   - zero if none of the above conditions are met.
#
#   - one if, e.g., --with-qt is passed but no QTDIR is set, or
#   --with-QTDIR=/path points to an invalid path.
#    
#   - return code from the qt test.

# = toc_end_help
toc_add_config_h HAVE_QT=0
toc_add_make configure_with_qt=${configure_with_qt-0}

test "x${configure_with_qt}" = "x0" && {
    echo "Qt support has been explicitely disabled."
    return 0
}
use_qt=${configure_with_qt-0}
test "x${configure_with_QTDIR}" = "x1" && configure_with_QTDIR="$QTDIR"
test "x${configure_with_QTDIR}" != "x" && {
    thedir="${configure_with_QTDIR}"
    test -d "$thedir" || {
        echo "Specified QTDIR does not exist: ${thedir}"
        return 1
    }
    configure_with_QTDIR=$thedir
    QTDIR=$thedir
    use_qt=1
}

if test "$use_qt" = "0"; then
    echo "Neither a valid --with-QTDIR=... nor --with-qt have been set. Not including Qt checks.";
    return 0
fi

qt_required_version=${qt_required_version-'3.x'}
qt_required_version_glob=${qt_required_version_glob-'3.*'}

toc_test qt "$@" || {
    err=$?
    echo "Qt $qt_required_version not found."
    return $err
}
configure_with_qt=1
toc_add_make configure_with_qt=${configure_with_qt}
toc_add_config_h HAVE_QT=1

return 0
