#include <iostream>
#include <fstream>
#include <sstream>
#include <map>
#include <stdio.h> //fopen()/fread()

#include "file_util.h"

#include <PACKAGE_NAMESPACE/debuggering_macros.h> // COUT macro


#if HAVE_CONFIG_H
#include "config.h" // expected: HAVE_ZLIB, HAVE_BZLIB
#endif

#include <fstream>

#if HAVE_ZLIB
#  include <PACKAGE_NAMESPACE/gzstream.h>
#endif
#if HAVE_BZLIB
#  include <PACKAGE_NAMESPACE/bzstream.h>
#endif

namespace PACKAGE_NAMESPACE {



        static CompressionPolicy m_comp_policy = PACKAGE_NAMESPACE::NoCompression;
        void compression_policy( CompressionPolicy c )
        {
                //CERR << "compression_policy = " << c << std::endl;
                m_comp_policy = c;
        }
        CompressionPolicy compression_policy()
        {
                return m_comp_policy;
        }


        std::istream * get_istream( const std::string & src, bool AsFile )
        {
                // if( "-" == src ) return &std::cin; // i'd like
                // that, but clients will then delete it :/. One option
                // might be via tie(), but i have no experience with it.

                if( ! AsFile )
                {
                        return new std::istringstream( src );
                }


                //CERR << "get_istream("<<src<<")"<<std::endl;
                enum FTypes { Unknown, GZip, BZip };

                std::ifstream check( src.c_str() );
                if( ! check.good() ) return NULL;

                
                FILE * inf = fopen( src.c_str(), "rb" );
                if( ! inf )
                {
                        CERR << "fopen("<<src<<") failed!" << std::endl;
                        return NULL;
                }
                unsigned char buff[4];
                fread( buff, sizeof(buff), 1, inf );
                fclose( inf );
#if HAVE_BZLIB
                // bzip=5a42 3968 (dec: 90 66 57 104) ascii: ZB9h
                if( 'B' == buff[0] && 'Z' == buff[1] )
                {
                        //COUT << "bzip!"<<std::endl;
                        return new PACKAGE_NAMESPACE::ibzstream( src.c_str() );
                }
#endif                
#if HAVE_ZLIB
                // gzip=8b1f 0808 (dec: 139 31 8 8)
                if( 0x1f == buff[0] && 0x8b == buff[1] ) // maybe a bug here? 
                        // this ordering is probably big/little endian dependent(?)
                {
                        //COUT << "gzip!"<<std::endl;
                        return new PACKAGE_NAMESPACE::igzstream( src.c_str() );
                }
#endif            
                return new std::ifstream( src.c_str() );
        }

        std::ostream *
        get_ostream( const std::string & fname )
        {
                switch( PACKAGE_NAMESPACE::compression_policy() )
                {
#if HAVE_ZLIB
                  case GZipCompression: return new PACKAGE_NAMESPACE::ogzstream( fname.c_str() );
#endif
#if HAVE_BZLIB
                  case BZipCompression: return new PACKAGE_NAMESPACE::obzstream( fname.c_str() );
#endif
                  default:
                          return new std::ofstream( fname.c_str() );
                }
        }


        std::string bytes_from_file( const std::string &fn, unsigned int count, bool read_past_nl )
        {
                typedef std::map<std::string,std::string> Map;
                static Map cache;
                Map::iterator it = cache.find( fn );
                if( it != cache.end() ) return (*it).second;

                std::istream * is = 0;
                is = PACKAGE_NAMESPACE::get_istream( fn );
                if( ! is ) return std::string();
                if( !is->good() )
                {
                        delete( is );
                        return std::string();
                }
                is->unsetf(std::ios_base::skipws);
                std::string line;
                char c;
                for( unsigned int i = 0; i < count; i++ )
                {
                        *is >> c;
                        if( (!read_past_nl) && '\n' == c ) break;
                        if( ! is->good() ) break;
                        line += c;
                }
                delete( is );
                cache[fn] = line;
                return line;
        }



} // namespace PACKAGE_NAMESPACE
