////////////////////////////////////////////////////////////////////////
// supermacro for registering std::maps.
// It's functionally identical to using reg_proxy.h except that it 
// adds a proxy for the map's value_type, which is necessary for
// some deserialization operations.
////////////////////////////////////////////////////////////////////////
// Usage:
// Exactly as for reg_proxy.h, except leave of the
// S11N_[DE]SERIALIZER_FUNCTOR assignment.
//
// Note: this cannot be implemented in terms of simply including
// the reg_proxy.h calls for a map and a pair because of the way
// the supermacro arguments are unset during each call, which means
// we cannot expand the map's S11N_TYPE to S11N_TYPE::value_type.
// Thus, we do this the hard way and implement a whole SAM by hand.
// At least it's only once for all map types. :/
////////////////////////////////////////////////////////////////////////

#ifndef S11N_TYPE
#    error "S11N_TYPE is not set. Set it to the type you want to proxy before including this file!"
#endif

#ifndef S11N_NAME
#    error "S11N_NAME must be set to the string form of S11N_TYPE"
#endif

#include <S11N_NS/map.h> // map-related s11n funcs

////////////////////////////////////////////////////////////////////////
// internal macros:
#define S11N_SERIALIZE_FUNCTOR S11N_NS::map::map_serializer_proxy
#define S11N_VALUE_TYPE_SERIALIZE_FUNCTOR S11N_NS::map::pair_serializer_proxy
#define S11N_VALUE_TYPE S11N_TYPE::value_type
#define S11N_VALUE_TYPE_NAME "pair"

////////////////////////////////////////////////////////////////////////
// set up the type name registry
#define NAME_TYPE S11N_TYPE
#define TYPE_NAME S11N_NAME
#include <S11N_NS/name_type.h>
#define NAME_TYPE S11N_VALUE_TYPE
#define TYPE_NAME S11N_VALUE_TYPE_NAME
#include <S11N_NS/name_type.h>
////////////////////////////////////////////////////////////////////////


namespace { // anonymous namespace is important for complex linking reasons.


#ifndef S11N_NS_MAP_REG_CONTEXT_DEFINED
#define S11N_NS_MAP_REG_CONTEXT_DEFINED 1
#include <S11N_NS/debuggering_macros.h> // CERR
#include <iostream> // cerr
        ///////////////////////////////////////////////////////////////
        // we must not include this more than once per compilation unit
        ///////////////////////////////////////////////////////////////
        // A unique (per Context/per compilation unit) space to assign
        // a bogus value for classloader registration purposes (see
        // the classloader docs for a full description of how this
        // works).
        template <typename Context>
        struct map_reg_context
        {
                typedef Context context;
                static bool placeholder;
                static void reg()
                {
                        CERR << "Warning: this type is unspecialized, which mean no registration "
                             << "has been made for the context type ["<<::classname< context >() << "]\n"
                             << "This type is:\n"<<::classname<map_reg_context<context> >() << "\n";
                        
                }
        };
        template <typename Context> bool map_reg_context<Context>::placeholder = false;
#endif
// !S11N_NS_MAP_REG_CONTEXT_DEFINED
////////////////////////////////////////////////////////////////////////////////

        	


        ////////////////////////////////////////////////////////////////////////
        // Register a factory with the classloader (this could be done any
	// number of ways, actually):
        template <>
        struct map_reg_context< S11N_TYPE >
        {
                static bool placeholder;
                static void reg()
                {
                        S11N_NS::classloader_register<
                                S11N_TYPE,
                                S11N_TYPE
                                >( ::classname< S11N_TYPE >() );

                        S11N_NS::classloader_register<
                                S11N_VALUE_TYPE,
                                S11N_VALUE_TYPE
                                >( ::classname< S11N_VALUE_TYPE >() );

                }
        };

	bool map_reg_context< S11N_TYPE >::placeholder= (map_reg_context< S11N_TYPE >::reg(),true);

        ////////////////////////////////////////////////////////////////////////
        // give s11n de/serialize implementations for S11N_TYPE:
	template <> struct s11n_api_marshaler< S11N_TYPE >
        {
                typedef S11N_TYPE serializable_type;
                typedef S11N_SERIALIZE_FUNCTOR serialize_proxy_type;
                typedef serialize_proxy_type deserialize_proxy_type;
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname< S11N_TYPE >() );
                        //dest.impl_class( ::clname::classname( &src ) );
                        return serialize_proxy_type()( dest, src );
                }

                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest ) 
                {
                        return deserialize_proxy_type()( src, dest );
                }
        }; // struct s11n_api_marshaler< S11N_TYPE >

        ////////////////////////////////////////////////////////////
        // proxy the map's value_type
	template <> struct s11n_api_marshaler< S11N_VALUE_TYPE >
        {
                typedef S11N_VALUE_TYPE serializable_type;
                typedef S11N_VALUE_TYPE_SERIALIZE_FUNCTOR serialize_proxy_type;
                typedef serialize_proxy_type deserialize_proxy_type;
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname< S11N_VALUE_TYPE >() );
                        return serialize_proxy_type()( dest, src );
                }

                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest ) 
                {
                        return deserialize_proxy_type()( src, dest );
                }
        }; // struct s11n_api_marshaler< S11N_VALUE_TYPE >

} // anon namespace 

////////////////////////////////////////////////////////////////////////////////
// end proxy code for [S11N_TYPE]
////////////////////////////////////////////////////////////////////////////////

#undef S11N_TYPE
#undef S11N_NAME
#undef S11N_SERIALIZE_FUNCTOR
#undef S11N_VALUE_TYPE
#undef S11N_VALUE_TYPE_NAME
#undef S11N_VALUE_TYPE_SERIALIZE_FUNCTOR
