#ifndef compact_SERIALIZER_H_INCLUDED
#define compact_SERIALIZER_H_INCLUDED 1

////////////////////////////////////////////////////////////////////////
// data_node_serializers.h: some file parsers for the s11n framework
//
// License: Public Domain
// Author: stephan@s11n.net
////////////////////////////////////////////////////////////////////////

#include "data_node_format.h" // base interfaces

#define MAGIC_COOKIE_COMPACT "51191011"
#define TAB(LEVEL,ECHO) indent = ""; for( size_t i = 0; i < depth + LEVEL; i++ ) { indent += '\t'; if(ECHO) dest << '\t'; }

namespace S11N_NS {
	namespace io {

                namespace sharing {
                        /**
                           Sharing context used by compact_serializer.
                        */
                        struct compact_sharing_context {};
                }

                /**
                   De/serializes objects from/to a compact binary-like grammar.
                */
                template <typename NodeType>
                class compact_serializer : public tree_builder_lexer<NodeType,sharing::compact_sharing_context>
                {
                public:
                        typedef NodeType node_type;

                        typedef compact_serializer<node_type> this_type; // convenience typedef
                        typedef tree_builder_lexer<node_type,sharing::compact_sharing_context> parent_type; // convenience typedef

                        compact_serializer() : parent_type( "compact_data_nodeFlexLexer" ),
                                              m_depth(0)
                        {
                                this->magic_cookie( MAGIC_COOKIE_COMPACT );
                        }

                        virtual ~compact_serializer() {}

                        typedef entity_translation_map translation_map;


                        /**
                           Writes src out to dest.
                        */
                        virtual bool serialize( const node_type & src, std::ostream & dest )
                        {
                                static const int ctrlwidth = 2;
                                static const int size2b = 2;
                                static const int size4b = 4;
                                static const int cookiewidth = 8;
                                
                                static const unsigned long Magic_Cookie_4B = 0x51191011;
                                static const unsigned long Node_Open = 0xf1;
                                static const unsigned long Node_Close = 0xf0;
                                static const unsigned long Prop_Open =  0xe1;
                                static const unsigned long Data_End = 0x51190000; // not strictly necessary



                                std::string nname = src.name();
                                std::string impl = src.impl_class();

                                std::string::size_type sizE = 0;
                                std::string::size_type ins;
                                // WTF must all this stream manip be done on every fucking insert?
#define OS_INT(C,W) dest.width(W);dest<<std::hex<<std::right<<(unsigned int)(C);
#define INSERT(vaR,WIDTH) sizE = vaR.size(); OS_INT(sizE,WIDTH); \
                for( ins = 0; ins < sizE; ins++ ) {\
			/*OS_INT(vaR[ins],charwidth);*/ \
			dest << (unsigned char) vaR[ins]; \
		};
                                size_t depth = this->m_depth++;
                                
                                if ( 0 == depth )
                                {
                                        dest.setf( std::ios_base::hex );
                                        dest.fill('0');
                                        dest.setf(std::ios_base::right, std::ios_base::adjustfield);
                                        OS_INT(Magic_Cookie_4B,cookiewidth);
                                        dest << '\n';
                                }

                                OS_INT(Node_Open,ctrlwidth);
                                INSERT(nname,size2b);
                                INSERT(impl,size2b);
                                typedef typename node_type::const_iterator CIT;
                                CIT it = src.begin();
                                CIT et = src.end();
                                std::string propval;
                                std::string propname;
                                for ( ; it != et; ++it )
                                {
                                        OS_INT(Prop_Open,ctrlwidth);
                                        propname = ( *it ).first;
                                        INSERT(propname,size2b);
                                        propval = ( *it ).second;
                                        INSERT(propval,size4b);
                                        //OS_INT(Prop_Close);
                                }

                                std::for_each( src.children().begin(),
                                               src.children().end(),
                                               node_child_simple_formatter<this_type>( *this, dest,"","" )
                                               );

                                OS_INT(Node_Close,ctrlwidth);
                                dest << '\n';
                                if( 0 == depth )
                                {
                                        OS_INT(Data_End,cookiewidth);
                                        dest << std::endl;
                                        // maintenance: dest must be flush()ed or the client may be forced to do it.
                                }
                                --this->m_depth;
                                return true;
                        }
#undef OS_INT
#undef INSERT



                private:
                        size_t m_depth;
                        static const std::string m_open;
                        static const std::string m_close;
                };
                template <typename NodeType>
                const std::string compact_serializer<NodeType>::m_open = "(";
                template <typename NodeType>
                const std::string compact_serializer<NodeType>::m_close = ")";

	} // namespace io
} // namespace S11N_NS

#undef TAB

#endif // compact_SERIALIZER_H_INCLUDED
