inherit "roxenlib";
inherit "module";
#include <module.h>;

/*
 * This software is (C) 1998 Francesco Chemolli,
 * and is freely availible under the terms of the
 * GNU General Public License, version 2.
 * This software comes with NO WARRANTY of ANY KIND, EITHER IMPLICIT
 * OR EXPLICIT. Use at your own risk.
 *
 * This is a _TELNET_ proxy module for Roxen.
 * It will allow you to work around sites having a firewall
 * but _NOT_ for HTTP (like my university :P).
 * Using it is very simple, just add it to your virtual server,
 * (i.e. foo.bar.org, port 80), then
 * $ telnet foo.bar.org 80
 * GET telnet://some.other.host.com
 *
 * (notice the _double_ carriage return), and you'll be connected
 * to the host.
 * You can specify a port as
 * GET telnet://some.other.host.com:12345
 * And you're in business.
 */

//#define TELNETPROXY_DEBUG
/*
 * Define this to enable debugging. It will also be turned on if DEBUGLVL is
 * >= 22 (the same as http proxy)
 */
//#define TELNETPROXY_TRY_LOGGING
/*
 * I'd like to try to write to a logfile what's happening.
 * But I don't seem to be able to do it (I succeeded only once,
 * It would seem like traffic to be 0 in the resultmapping, but I don't
 * understand why.
 */

/*
 * Notice that Connection is not a class proper, as the module accesses its
 * variables directly. But it's not worth the effort for such a simple
 * thing...
 */

constant cvs_version="$Id: telnetproxy.pike,v 1.4 1998/03/29 22:24:05 kinkie Exp kinkie $";

#if DEBUG > 22
#define TELNETPROXY_DEBUG
#endif

#ifdef TELNETPROXY_DEBUG
#define debug_perror perror
#else
#define debug_perror
#endif

/*
 * A bidirectional pipe over HTTP.
 */
class Connection
{
	object *fdescs;
	mapping buffer;
	object mastermodule, master_id;
	int traffic=0;

	object otherfd (object fd) {
		if (fd==fdescs[0])
			return fdescs[1];
		else
			return fdescs[0];
	}

	void send(object to_fd, string data) {
		int sent=0;
		debug_perror("Send("+data+")\n");
		if(!strlen(buffer[to_fd]))
			buffer[to_fd] = data[(sent=to_fd->write(data))..];
		else
			buffer[to_fd] += data;
		traffic += sent;
	}

	void got_data(object f, string data) {
		debug_perror ("Got data from "+(f?f->query_address():"unknown")+": "+data+"\n");
		send(otherfd(f),data);
	}

	void client_closed() {
		debug_perror("Client closed connection.\n");
		destruct(this_object());
	}

	void write_more(object f)
	{
		debug_perror("Write_more..");
		if(strlen(buffer[f]))
		{
			int written = otherfd(f)->write(buffer[f]);
			traffic += written;
			debug_perror((string)written);
			if(written == 0)
				client_closed();
			else
				buffer[f] = (buffer[f])[written..];
		}
		debug_perror("\n");
	}

	void create(object s, object d, object m, object id)
	{
		fdescs=({s,d});
		buffer=([s:"",d:""]);
		s->set_nonblocking(got_data,write_more,client_closed);
		s->set_id(s);
		d->set_nonblocking(got_data,write_more,client_closed);
		d->set_id(d);
		mastermodule=m;
#ifdef TELNETPROXY_TRY_LOGGING
		master_id=id;
#endif
		debug_perror("Got connection from "+s->query_address()+
				" to " + d->query_address()+"\n");
	}

	void destroy() {
		mapping result;
		debug_perror("Destroy\n");
		fdescs[0]->close();
		fdescs[1]->close();
		mastermodule->connections-=(<this_object()>);
#ifdef TELNETPROXY_TRY_LOGGING
		result=([
				"len":traffic,
				"type":"text/plain",
				"leave_me":0,
				"error":200
				]);
		master_id->conf->log(result,master_id);
#endif
	}
};

array register_module() {
	return ({
			MODULE_PROXY|MODULE_LOCATION,
			"Telnet Proxy",
			"This proxy-module is meant as a work-around to some nasty "
			"firewalls<BR>\n"
			"&copy; 1998 Francesco Chemolli "
			"&lt;kinkie@kame.usr.dsi.unimi.it&gt;,<BR>\nfreely distributed "
			"under the terms of the GNU General Public License, version 2"
			});
}

string query_location() {
	return QUERY(mountpoint);
}

multiset connections=(<>);

mapping find_file (string f, object id) {
	object src, dst;
	object c1, c2;
	object connection;
	int n, port=23;
	string host=f;
	if ((n=search(host,"/"))>=0) {
		host=host[..n];
	}
	if (search(host,":"))
		sscanf(host,"%s:%d",host,port);
	id->do_not_disconnect=1;
	src=id->my_fd;
	//could use async_connect instead of this: it would not block,
	//but I'd be on my own in describing errors...
	dst=files.file();
	dst->open_socket();
	if (!dst->connect(host,port)) {
		throw(
				({
				 "Could not initiate connection: \n"+strerror(dst->errno()),
				 backtrace()
				 })
				);
	}
	connection=Connection(src,dst,this_object(),id);
	connections[connection]=1;
	return http_pipe_in_progress();
}

string status() {
	object req;
	if (!sizeof(connections)) {
		return "<B>No connections</B>";
	}
	string retval;
	retval="<B>"+sizeof(connections)+" connections</B><BR>\n";
	retval += "<TABLE border=1><TR><TH align=center>From<TH>To<TH>Traffic";
	foreach(indices(connections),req) {
		retval+=sprintf("<TR><TD>%s<TD>%s<TD>%d",
				req->fdescs[0]->query_address(),
				req->fdescs[1]->query_address(),
				req->traffic
				);
	}
	retval += "</TABLE>";
	return retval;
}

void create() {
	defvar ("mountpoint", "telnet:/", "Location",
			TYPE_LOCATION|VAR_MORE,
			"This is the mountpoint in the virtual filesystem of this "
			"module. Leave it as default unless you're sure you know what "
			"you're doing. To use this proxie's features, telnet to your "
			"virtual server, and type: <BR>"
			"<PRE>GET telnet://hostname[:port][/...] HTTP/1.0 \\n\\n</PRE>"
			);
}
