# Your kernel version, tries to auto-detect here
%define kernelversion %(uname -r)

%define name    lufs
%define version 0.8.2

Summary:	lufs - Linux Userland File System
Name:		%{name}
Version:	%{version}
Release:	1
License:	GPL
Group:		Base
Source0:	%{name}-%{version}.tar.gz
Patch1:     lufs-rpmbuild.patch

BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	libtool
#BuildRequires:	kernel-source = %{kernelversion}

Requires:   kernel = %{kernelversion}

BuildRoot:	/tmp/buildroot-%{name}-%{version}

%description
LUFS is a hybrid userspace filesystem framework supporting many filesystems:
sshfs, ftpfs, localfs, locasefs, gvfs, cardfs, cefs, etc.  Lots of other 
"exotic" filesystems are in the planning phase: socketfs, httpfs, freenetfs
and others.


%prep
%setup -q

%patch1 -p1

%build
%{__libtoolize}
aclocal
%{__autoconf}
%{__automake}
%configure \
	--with-kernel=%{kernelversion} \
	--with-kheaders=/lib/modules/%{kernelversion}/build/include 
%{__make}

%install
rm -rf $RPM_BUILD_ROOT

%{__make} install \
	DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%post

ln -s /usr/bin/auto.sshfs /etc/auto.sshfs
ln -s /usr/bin/auto.ftpfs /etc/auto.ftpfs
ln -s /usr/bin/lufsd /sbin/mount.lufs

depmod -a

if [ "`lsmod | grep lufs`" ]; then rmmod lufs; fi

modprobe lufs

%preun

if [ "`lsmod | grep lufs`" ]; then rmmod lufs; fi

%postun

depmod -a

rm -f /etc/auto.sshfs
rm -f /etc/auto.ftpfs
rm -f /sbin/mount.lufs


%files
%defattr(644,root,root)

/lib/modules/%{kernelversion}/kernel/fs/lufs/lufs.o
/etc/lufsd.conf

%defattr(755,root,root)

/usr/bin/lufsd
/usr/bin/lussh
/usr/bin/lufsmount

/usr/bin/auto.sshfs
/usr/bin/auto.ftpfs

# These are SUID root...

%defattr(4755,root,root)
/usr/bin/lufsmnt
/usr/bin/lufsumount


%changelog
* Sun Nov 24 2002 Dave Wilson <dave@...>
- initial version
