# Copyright (C) 2001,2004 Stichting LogReport Foundation logreport@logreport.org

# This file is part of Lire.

# Lire is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program (see COPYING); if not, check with
# http://www.gnu.org/copyleft/gpl.html or write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

# Authors:
#   E.L. Willighagen <egonw@logreport.org>
#   Francis J. Lacoste <flacoste@logreport.org>

package Lire::DlfAnalysers::RobotCategoriser;

use strict;

use base qw/Lire::DlfCategoriser/;

use Lire::WWW::Domain;
use Lire::WWW::UserAgent;

sub new {
    return bless {}, shift;
}

sub name {
    return "www-robot";
}

sub title {
    return "Robot DlfAnalyser";
}

sub description {
    return '<para>This categoriser detects request made by web robots based on 
information contained in the <structfield>client_host</structfield> and <structfield>useragent</structfield>.</para>';
}

sub src_schema {
    return "www";
}

sub dst_schema {
    return "www-robot";
}

sub initialise {
    my ( $self, $config ) = @_;

    $self->{'domain_analyser'} =
      new Lire::WWW::Domain( 'robot_default' => 'LIRE_UNDEF' );
    $self->{'ua_analyser'} =
      new Lire::WWW::UserAgent( 'robot_default' => 'LIRE_UNDEF' );

    return;
}

sub categorise {
    my ( $self, $dlf ) = @_;

    if ( defined $dlf->{'client_host'} ) {
        $self->{'domain_analyser'}->setDomain( $dlf->{'client_host'} );
        $dlf->{'robot'} = $self->{'domain_analyser'}->getRobot();
        $dlf->{'robot'} = undef
          if $dlf->{'robot'} eq 'LIRE_UNDEF';
    }
    if ( defined $dlf->{'useragent'} && ! defined $dlf->{'robot'} ) {
        $self->{'ua_analyser'}->setUserAgent( $dlf->{'useragent'} );
        $dlf->{'robot'} =  $self->{'ua_analyser'}->getRobot();
        $dlf->{'robot'} = undef
           if $dlf->{'robot'} eq 'LIRE_UNDEF';
    }

    return;
}

# keep perl happy
1;
