package Lire::Config::BooleanSpec;

=pod

=head1 NAME

Lire::Config::BooleanSpec - Type that represents a boolean

=head1 DESCRIPTION

Values of this type are yes/no values.

These values are normalized to 0 or 1.

=cut

use base qw/Lire::Config::ScalarSpec/;

sub is_valid {
    my ( $self, $val ) = @_;

    return !$self->required() unless defined $val;

    return 1 if !$val;

    return scalar $val =~ /^(0|1|f|false|true|t|no|off|disabled|enabled|yes|on)$/i;
}

sub normalize {
    my ( $self, $val ) = @_;

    return undef unless defined $val;

    return ! 1 if !$val;

    return ! scalar $val =~ /^(0|f|false|no|off|disabled)$/i;
}

1;
__END__

=pod

=head1 VERSION

$Id: BooleanSpec.pm,v 1.2 2004/07/21 21:28:30 flacoste Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
