//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


// Definition of the request class

#ifndef _xmlrpc_request_class_
#define _xmlrpc_request_class_

#include <string>
#include <vector>

#include "xml.hpp"
#include "param.hpp"

namespace xmlrpc
{

  class request : public xml::persistable
  {
  public:

    request ( const std::string name = "" );
    virtual ~request();

    //
    // Methods you are interested in
    //
    std::string get_name() const { return m_name; }

    void add_param ( const param p ) { m_params.push_back ( p ); }
    param get_param ( const std::string name ) const;



    //
    // Methods used internally
    // by the framework
    //
    virtual std::string get_xml() const;
    virtual void load_xml ( const std::string );

    std::string terminator() const { return "abcdef_request_end_abcdef"; }

  private:

    std::vector<param> m_params;
    std::string m_name;
  };
};

#endif
