/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <syslog.h>
#include <ctype.h>

#include "ldapdiff.h"

static void ldiflogstdout(char *msg)
{
 time_t       t;

 t = time(NULL);
 printf("%s: %s\n",strtok(ctime(&t),"\n"),msg);
}

static void ldiflogfile(char *msg)
{
 extern char *logfile;
 FILE        *f;
 time_t       t;

 if((f = fopen(logfile,"a")) == NULL){
  fprintf(stderr,"fopen() of %s failed: file: %s, line: %d\n",logfile,__FILE__,__LINE__
);
   exit(-1);
 }

 t = time(NULL);
 fprintf(f,"%s: %s\n",strtok(ctime(&t),"\n"),msg);

 fclose(f);
}

static void ldiflogsyslog(int aloglevel, char *msg)
{
 extern int facility;
 int        level = LOG_ERR;

 openlog(SYSLOGNAME,LOG_ODELAY,facility);
 switch(aloglevel){
  case LOG0:  level = LOG_ERR;
       break;
  case LOG1:  level = LOG_INFO;
       break;
  case LOG2 : level = LOG_DEBUG;
       break;
 }
 syslog(level,msg);
 closelog();
}

void ldiflogval(teloglevel aloglevel,char *s,char* var,char *val,size_t val_len)
{
 char *tval;

 tval = LDALLOC(1,val_len + 1);
 if(val != NULL){
  memcpy(tval,val,val_len);
 }
 ldiflog(aloglevel,s,var,tval);
 free(tval);
}

void ldiflog(teloglevel aloglevel,char *s,...)
{
 extern int   facility;
 extern int   loglevel;
 extern char *logfile;
 int          i = 0;
 int          j = 0;

 char buf[MAXATTRLEN];
 char pbuf[MAXATTRLEN];

 va_list ap;

 if(aloglevel > loglevel){
  return;
 }

 va_start(ap,s);
 vsprintf(buf,s,ap);
 va_end(ap);

 for(i=0;i<strlen(buf);i++){
  if(isalnum(buf[i]) || ispunct(buf[i]) || isspace(buf[i])){
   pbuf[j++] = buf[i];
  }
  else{
   sprintf(pbuf+j,"[%3.3o]",(unsigned char)buf[i]);
   j += 5;
  }

  if(j >= MAXLOGLEN){
   sprintf(pbuf+j,"[...]");
   j += 5;
   break;
  }
 } 
 pbuf[j] = '\0';
 
 if(facility != -1){
  ldiflogsyslog(aloglevel,pbuf);
 }
 else if(logfile != NULL){
  ldiflogfile(pbuf);
 }
 else{
  ldiflogstdout(pbuf);
 }
}
