#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

#!/usr/local/bin/tclsh
## a simple script to substitute one config line for
## another. To be called from a Makefile.
## Only works for the expression described below.
## This would be best done with 2 lines of perl,
## but we're already assuming tcl works since we're
## installing tcl scripts. launcher version 0.52

if {$argc != 3} {
    puts "usage: config.tcl infile outfile newpath"
    exit
}

set fd1 [open "[lindex $argv 0]" r]
set fd2 [open "[lindex $argv 1]" w]
set newpath "[lindex $argv 2]"

set sub "\\1\"$newpath\""

while {[gets $fd1 line] != -1} {
    regsub {^(set etcdir )(.*)} $line $sub line
    puts $fd2 $line
}
