//LabPlot : Ellipse.cc

#include <math.h>
#include <iostream>
#include <kdebug.h>
#include "Ellipse.h"

using namespace std;

Ellipse::Ellipse(Point s,Point e,QColor c,int w, bool f, QColor fi) {
	start = s;
	end = e;
	color = c;
	width = w;
	filled = f;
	fill = fi;
}

QStringList Ellipse::Info() {
	QStringList s;

        s << QString::number(start.X())+"/"+QString::number(start.Y());
        s << QString::number(end.X())+"/"+QString::number(end.Y());
	s << QString::number(width);
        s << color.name();
	s << QString::number(filled);
	s << fill.name();

	return s;
}

// draw the line on the worksheet
void Ellipse::draw(QPainter *p, double X, double Y) {
	//kdDebug()<<"DRAW Ellipse from "<<X*start.X()<<'/'<<Y*start.Y()<<" to "<<X*end.X()<<'/'<<Y*end.Y()<<endl;

	QPen pn = p->pen();
        pn.setWidth(width);
        pn.setColor(color);
        p->setPen(pn);
	if (filled)
		p->setBrush(fill);
	else
		p->setBrush(Qt::NoBrush);
	p->drawEllipse((int)(X*start.X()),(int)(Y*start.Y()),
		(int)(X*end.X()),(int)(Y*end.Y()));
}

// save
void Ellipse::save(QTextStream *t) {
	*t<<start.X()<<' '<<start.Y()<<' '<<end.X()<<' '<<end.Y()<<endl;
	*t<<color.name()<<' '<<width<<' '<<filled<<' '<<fill.name()<<endl;
}

// open
void Ellipse::open(QTextStream *t,int version) {
	double sx,sy,ex,ey;
	QString colorstring,fillstring;
	int f;
	
	*t>>sx>>sy>>ex>>ey;

	start.setPoint(sx,sy);
	end.setPoint(ex,ey);
	
	*t>>colorstring>>width>>f>>fillstring;
	color=QColor(colorstring);
	filled=f;
	fill=QColor(fillstring);
}

bool Ellipse::inside(int x, int y, int w, int h) {
        double W = w*end.X();
        double H = h*end.Y();
	double mx = w*start.X()+W/2;
        double my = h*start.Y()+H/2;

	// foci x values
	double f1x = mx-sqrt(W*W-H*H)/2.0;
	double f2x = mx+sqrt(W*W-H*H)/2.0;

	double d = sqrt((double)((x-f1x)*(x-f1x)+(y-my)*(y-my)))+
		 sqrt((double)((x-f2x)*(x-f2x)+(y-my)*(y-my)));
	
	//kdDebug()<<"Ellipse : D = "<<d<<" W : "<<W<<endl;
		 
	if (d<W)
		return TRUE;
	return FALSE;
}
