#ifndef _KVI_SIMPLE_FINDWIDGET_H_INCLUDED_
#define _KVI_SIMPLE_FINDWIDGET_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

class QCheckBox;

class KviLineEdit;
class KviPushButton;
class KviSimpleEditor;

class KviSimpleFindWidget : public QFrame
{
	friend class KviSimpleEditor;

	Q_OBJECT
public:
	KviSimpleFindWidget(KviSimpleEditor *parent);
	~KviSimpleFindWidget();

	bool focusNextPrevChild(bool);
protected slots:
	void selectionChanged();
	void findNextClicked();
	void findPrevClicked();
	void replaceAllClicked();
	void replaceAndFindNextClicked();
	void replaceAllInSelectionClicked();
protected:
	QPoint           m_pressPoint;
	KviSimpleEditor *m_pEditor;
	KviLineEdit     *m_pFindStringEdit;
	KviLineEdit     *m_pReplaceStringEdit;
	QCheckBox       *m_pRegexpCheckBox;
	QCheckBox       *m_pCaseSensitiveCheckBox;
	KviPushButton   *m_pReplace;
	KviPushButton   *m_pReplaceAndFindNext;
	KviPushButton   *m_pReplaceAllInSelection;

	virtual void mousePressEvent(QMouseEvent *);
	virtual void  mouseMoveEvent(QMouseEvent *);
};

#endif // _KVI_SIMPLE_FINDWIDGET_H_INCLUDED_
