#ifndef _KVI_MIRCCNTRL_H_
#define _KVI_MIRCCNTRL_H_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#undef __kvi_extern
#ifdef _KVI_MIRCCNTRL_CPP_
	#define __kvi_extern
#else
	#define __kvi_extern extern
#endif

#include <qglobal.h>

class QString;

// =============================================================================
// This file contains non-customizable standards
//
// Better not touch this :)
// =============================================================================

__kvi_extern const char *getColorBytes(const char *data_ptr, unsigned char *byte_1, unsigned char *byte_2);
__kvi_extern const Q_UINT16 *getColorBytesW(const Q_UINT16 *data_ptr, unsigned char *byte_1,unsigned char *byte_2);
__kvi_extern unsigned int getUnicodeColorBytes(
	const QString &szData, unsigned int charIdx, unsigned char *byte_1, unsigned char *byte_2
);

// ===========================================================================
// mIrc colors order
// *Do not change*
// ===========================================================================
#define KVI_WHITE          0
#define KVI_BLACK          1
#define KVI_DARKBLUE       2
#define KVI_DARKGREEN      3
#define KVI_RED            4
#define KVI_DARKRED        5
#define KVI_DARKVIOLET     6
#define KVI_ORANGE         7
#define KVI_YELLOW         8
#define KVI_LIGHTGREEN     9
#define KVI_BLUEMARINE    10
#define KVI_LIGHTBLUE     11
#define KVI_BLUE          12
#define KVI_LIGHTVIOLET   13
#define KVI_DARKGRAY      14
#define KVI_LIGHTGRAY     15

//
// Non-standard color codes for KviIrcView
//
#define KVI_TRANSPARENT 100
#define KVI_NOCHANGE    101

//
// Internal control codes for KviIrcView
// Totally artificial and internal to KviIrcView
//
#define KVI_TEXT_ESCAPE     0x04
#define KVI_TEXT_UNESCAPE   0x05
#define KVI_TEXT_UNICON     0x06

#define KVI_TEXT_TAB        0x09

// ASCII stuff: the following defines are meant to be escape sequences
// that can go through an IRC connection.
//
// The following table is a 30 minute analysis of the escape characters commonly used over the IRC protocol,
// created when looking for a good placement for the CRYPT escape char in KVIrc.
// I guess that the best chars to be used are FS, GS, RS, US, DC1, DC2, DC3, DC4; they have the "less defined"
// meaning as ASCII control chars.

// ASCII                              IRC meaning
// -----                              -----------
// 000 NUL Null                       Cannot be assigned
// 001 SOH Start of heading           CTCP escape: only beginning of the message
// 002 STX Start of text              Bold text
// 003 ETX End of text                Color text escape sequence
// 004 EOT End of transmission        Assigned internally (escape)
// 005 ENQ Enquiry (WRU: Who are you) Assigned internally (unescape)
// 006 ACK Acknowledge                Not so good, but can be used as last resource
// 007 BEL Bell                       Recognized as bell by terminals and IRCII (also used by some IRC servers)
// 008 BS  Backspace                  Should not be assigned: terminal control
// 009 HT  Horizontal tabulation      Should not be assigned: terminal control
// 010 LF  Line feed                  Should not be assigned: terminal control
// 011 VT  Vertical tabulation        Should not be assigned: terminal control
// 012 FF  Form feed                  Should not be assigned: terminal control
// 013 CR  Carriage return            Should not be assigned: terminal control
// 014 SO  Shift out                  Should not be assigned: terminal control
// 015 SI  Shift in                   Resets bold, color, underline and reverse (conflicting with terminal control)
// 016 DLE Data link escape           Decent, can be assigned
// 017 DC1 Device control 1           Good to be assigned
// 018 DC2 Device control 2           Good to be assigned
// 019 DC3 Device control 3           Good to be assigned
// 020 DC4 Device control 4           Good to be assigned
// 021 NAK Negative acknowledge       Not so good, but could be used as last resource
// 022 SYN Synchronous idle           Reverse text
// 023 ETB End of transmission block  Decent, can be assigned
// 024 CAN Cancel                     Should not be assigned: terminal control
// 025 EM  End of medium              Decent, can be assigned
// 026 SUB Substitute                 Should not be assigned: terminal control
// 027 ESC Escape                     Should not be assigned: terminal control
// 028 FS  File separator             Excellent, should be used as first candidate
// 029 GS  Group separator            ICONS escape: beginning of a word
// 030 RS  Record separator           CRYPT escape: only beginning of the message
// 031 US  Unit separator             Underline text

// ===========================================================================
// mIrc color codes and general KviIrcView control codes
// *Do not change*
// ===========================================================================

// mIrc control codes
// 31 (0001 1111) US (Unit separator)
#define KVI_TEXT_UNDERLINE 0x1f
//  2 (0000 0010) STX (Start of text)
#define KVI_TEXT_BOLD      0x02
// 15 (0000 1111) SI (Shift in)
#define KVI_TEXT_RESET     0x0f
// 22 (0001 0110) SYN (Synchronous idle)
#define KVI_TEXT_REVERSE   0x16
//  3 (0000 0011) ETX (End of text)
#define KVI_TEXT_COLOR     0x03

// Irc control codes
//  1 (0000 0001) SOH (Start of heading)
#define KVI_TEXT_CTCP      0x01
#define KVI_QUERY_LINK     0x11  // Thought Ctrl-Q might be a good choice...

// KVirc added control codes
// 30 (0001 1110) RS (Record separator)
#define KVI_TEXT_CRYPT     0x1e
// 29 (0001 1101) GS (Group separator)
#define KVI_TEXT_ICON      0x1d

#endif // _KVI_MIRCCNTRL_H_
