/***************************************************************************
                          banddlg.cpp  -  description
                             -------------------
    begin                : Sat Oct 7 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>

#include <klocale.h>
#include "banddlg.h"
#include "globals.h"

bandDlg::bandDlg(QWidget *parent)
				: KDialogBase(parent, "banddlg", true, i18n("Bands"), Ok|Cancel, Ok, true) {
	setWFlags (WDestructiveClose);
	
	int i;
	QLabel* l;
	QWidget* w;
	QGridLayout* grid;

	w = new QWidget (this);
	setMainWidget (w);

	grid = new QGridLayout (w, -1, -1, 5, 5);

	for (i=0;i<12;++i) {
  	l = new QLabel (w);
		l->setText (config.band.band[i] + i18n (" Offset:"));
		grid->addWidget (l, i, 0, Qt::AlignRight);

		offsetEdit[i] = new QLineEdit (w);
		offsetEdit[i]->setText (QString::number (config.band.offset[i], 'f', 2));
		offsetEdit[i]->setFixedWidth(75);
		grid->addWidget (offsetEdit[i], i, 1, Qt::AlignRight);

		l = new QLabel (w);
		l->setText (i18n ("kHz"));
		grid->addWidget (l, i, 2, Qt::AlignLeft);
		
		lsbEdit[i] = new QCheckBox (w);
		lsbEdit[i]->setText (i18n ("LSB"));
		lsbEdit[i]->setChecked (config.band.lsb[i]);
		grid->addWidget (lsbEdit[i], i, 3, Qt::AlignLeft);
		}
}
bandDlg::~bandDlg()
{
}

void bandDlg::slotOk()
{
	int i;
	for (i=0;i<12;++i) {
		config.band.offset[i] = offsetEdit[i]->text().toDouble();
		config.band.lsb[i] = lsbEdit[i]->isChecked();
	}
	kpsk->reInit();
	KDialogBase::slotOk();
}
