/***************************************************************************
                          unmount.cpp  -  description
                             -------------------
    begin                : Tue Apr 11 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <kdebug.h>
#include "unmount.h"

Unmount::Unmount (QObject * parent, MyShareItem * share, bool clean):QObject
  (parent)
{
  shareitem = share;
  proc = 0;
  out = "";
  err = "";
  cleanup = clean;
}

Unmount::~Unmount ()
{
  if (proc)
    {
      kdWarning (7199) << "Umount : Process not exited..." << endl;
      proc->kill ();
      delete proc;
    }
}

/** Startet den mount-Process */
void
Unmount::start ()
{
  proc = new KProcess ();
  (*proc) << "smbumount" << shareitem->getMountPath ();
  connect (proc, SIGNAL (processExited (KProcess *)), this,
	   SLOT (onProcExit (KProcess *)));
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (umountStdout (KProcess *, char *, int)));
  connect (proc, SIGNAL (receivedStderr (KProcess *, char *, int)), this,
	   SLOT (umountStderr (KProcess *, char *, int)));
  proc->start (KProcess::NotifyOnExit, KProcess::All);

}

/* Ausgaben werden Abgefangen */
void
Unmount::umountStdout (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  out += b;
}

/* Ausgaben werden Abgefangen */
void
Unmount::umountStderr (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  err += b;
  kdDebug (7199) << "smbumount-error :" << b << endl;
}

/** Wird aufgerufen wenn der Process sich beendet */
void
Unmount::onProcExit (KProcess * killedproc)
{
  if (killedproc == proc)
    {
      delete proc;
      proc = 0;
    }
  else
    kdDebug (7199) << "Mmmhhh... not my process" << endl;
  if (cleanup)
    {
      QString path = shareitem->getMountPath ();
      QDir dir;
      dir.rmdir (path);

      path = path.left (path.length () - shareitem->Name ().length () - 1);
      dir.rmdir (path);

    }
  emit isExited (this, err, shareitem);
}
