/* @(#) main.c 1.47 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_MAIN_C "@(#) nitehawk@localhost.1ststep.net|src/main.c|20000827030155|46369 @(#)"

#include "autoconf.h"

#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "conf.h"

#include "daemon.h"
#include "log.h"
#include "sig.h"
#include "reboot.h"

#include "vm.h"
#include "module.h"

char cvsstrings[][100] =
{
	_KOALAMUD_VERSION_H,
	_KOALAMUD_KOALATYPES_H,
	_KOALAMUD_DAEMON_H,
	_KOALAMUD_LOG_H,
	_KOALAMUD_MAIN_C,
};

koalaoptions koptions = {  // Define the default values for options
	1,		// Verbosity
	DAEMON_UNKNOWN,	// Daemon type
	1,		// Background spawning - Default to using config file
	FALSE, 	// We were not rebooted
	DEFAULTTICKLEN,
	DEFAULTREPORTINGPERIOD,
	NULL,		// No default db path
};

koalastate kstate = {	// Setup the initial system state
	0,		// Node ID - must be unique on the network
	DSTATE_RUNNING,	// Start out 'RUNNING'
};

void displayversion(void)
{
	printf("%s", COPYRIGHTSTR);
}

void displayhelp(void)
{
	displayversion();
	printf("Usage:\n");
	printf(
"-h             Show this screen\n"
"-q             Lower verbosity level by 1\n"
"-v             Increse verbosity level by 1\n"
"                       Default verbosity is 1\n"
"-V             Display version information\n"
"-f             Don't spawn into background (default)\n"
"-b             Spawn into background\n"
"-g <path>      Generate default config file and exit\n"
"-c <path>      Read configuration from the specified file\n"
);
}

koalaerror parseoptions(int argc, char *argv[])
{
	char opt = EOF;		// Current Option
	const char optionlist[] = "hqVvfbg:c:r";	// Accepted Options
	bool configloaded = FALSE;

	opterr= 0;

	while ((opt = getopt(argc, argv, optionlist)) != -1)
	{
		switch (opt)
		{
		case 'h':  // User is requesting help
			displayhelp();
			exit(KESUCCESS);

		case 'g':
			exit(gendefaultconfig(optarg));

		case 'c':
			if (!configloaded)
			{
				if (readxmlconfig(optarg) == KESUCCESS)
					configloaded = TRUE;
			}
			else
			{
				logmsg(LOGERR, "Can only load one config file - ignoring");
			}
			break;

		case 'q':
			if (koptions.verbosity > 0)
				koptions.verbosity--;
			break;

		case 'v':
			if (koptions.verbosity < 10)
				koptions.verbosity++;
			break;

		case 'V':
			displayversion();
			exit(KESUCCESS);

		case 'f':
			koptions.spawnbackground = FALSE;
			break;

		case 'b':
			koptions.spawnbackground = TRUE;
			break;

		case 'r':
			kstate.running = DSTATE_REBOOTING;
			koptions.rebooted = TRUE;
			break;

		case '?':
			printf("Bad option '%c' on command line.\n",
				optopt);
			displayhelp();
			exit(KEBADOPT);

		case ':':
			printf("Option '%c' missing argument.\n",
				optopt);
			displayhelp();
			exit(KEMISSINGARG);

		default:
			printf("Bad option '%c' on command line.\n",
				optopt);
			displayhelp();
			exit(KEBADOPT);
		}

	}

	if (!configloaded)
	{
		readxmlconfig("koala.xml");
	}

	if (koptions.daemontype == DAEMON_UNKNOWN)
	{
		logmsg(LOGCRIT, "Invalid binary state.  Set daemon type"
				" in 'daemoninitstate'!");
		return KEBADOPT;
	}

	finddaemonconfig();
	
	return KESUCCESS;
}

int main(int argc, char *argv[])
{
	koalaerror kerr;
	int err;
	
	/* Module info structure has no dependancies on state */
	modinfoinit();

	/* Before we do anything, get some initial state information */
	daemoninitstate();

	/* setup standard logging */
	logpreinit();

	//loadmodule("mod_db", "lib/libkoalavm.so", MODTYPE_DATABASE, NULL);

	/* Startup the virtual memory driver */
//	vmstartup();

	/* Parse commandline options */
	if ((kerr =  parseoptions(argc, argv)) != KESUCCESS)
		return kerr;

	/* Code to spawn into background should go here */
	if ( koptions.rebooted == FALSE &&
			(((koptions.spawnbackground == 1) && confquerybackground()) ||
			((koptions.spawnbackground != 1) && koptions.spawnbackground)))
	{
		int status = -1;

		/* Fork into a separate process */
		status = fork();
		switch (status)
		{
		case -1:
			perror("fork()");
			exit(KEFORK);
		case 0:  // Child
			break;
		default: // Parent - die
			exit(KESUCCESS);
		}

		/* reopen standard handles to non-terminal files */
		fclose(stdin);
		fclose(stdout);
		fclose(stderr);

		/* switch process groups */
		status = setsid();
		if (status == -1)
		{
			perror("setsid()");
			exit(KEPGROUP);
		}

		/* Fork into a separate process */
		status = fork();
		switch (status)
		{
		case -1:
			perror("fork()");
			exit(KEFORK);
		case 0:  // Child
			break;
		default: // Parent - die
			exit(KESUCCESS);
		}
	}

	initsighandlers();

	confopenlogs();
	confgetoptions();

	logmsg(LOGINFO, "Opening log files");

	/* Bring the vm driver fully online */
//	vmlinkup();

	kerr = rundaemon();

	/* Whatever else we have to do, we need to shutdown the virtual memory
	 * driver */
//	vmshutdown();

	//unloadmodule("mod_db", NULL);

	/* Take final actions before shutting down or rebooting */
	if (kerr == KESUCCESS && kstate.running == DSTATE_REBOOT) {
		/* Get everything ready to reboot */
		if ((kerr = rebootdaemon()) != KESUCCESS)
		{
			logmsg(LOGERR, "Error saving reboot data, shutting down");
			return kerr;
		}

		/* If the last boot was from a reboot */
		if (koptions.rebooted)
		{
			/* we can just exec ourselves now */
			err = execv(argv[0], argv);
			return err;
		}
		else
		{
			/* we need to add -r to the arg list */
			char *args[argc + 2];
			int i;

			for (i=0; i<argc; i++)
			{
				args[i] = argv[i];
			}
			
			args[argc+1] = NULL;
			args[argc] = malloc(4);
			strcpy(args[argc], "-r");
			/* Now we can exec */
			err = execv(argv[0], args);
			return err;
		}
	}

	return kerr;
}
