h55854
s 00003/00000/00378
d D 1.57 00/11/04 22:11:16 nitehawk 58 57
c Fix memory leak in closing a connection
cC
cK31969
e
s 00000/00004/00378
d D 1.56 00/11/04 21:08:17 nitehawk 57 56
c Move do_modlist to modcommands.c in koalamod
cC
cK22391
e
s 00000/00008/00382
d D 1.55 00/11/04 20:41:49 nitehawk 56 55
c Remove registration of loadmod and unloadmod
cC
cK29731
e
s 00057/00001/00333
d D 1.54 00/11/04 18:51:42 nitehawk 55 54
c use daemoninitstate to initialize command table
c Switch parser usage to use new command parser
cC
cHwinghove.1ststep.net
cK44753
cZ-08:00
e
s 00001/00001/00333
d D 1.53 00/09/10 19:46:38 nitehawk 54 53
c parser.h -> kparser.h
cC
cK11765
e
s 00001/00085/00333
d D 1.52 00/09/10 19:32:14 nitehawk 53 52
c Move clientparsecommand to parser.c
cC
cK11658
e
s 00012/00011/00406
d D 1.51 00/08/26 19:52:49 nitehawk 52 51
c convert all logging calls into logmsg
cC
cK53181
e
s 00007/00009/00410
d D 1.50 00/08/22 20:17:49 nitehawk 51 50
c Converting to new logmsg
cC
cHlocalhost.1ststep.net
cK46998
cZ-07:00
e
s 00000/00001/00419
d D 1.49 00/03/07 18:12:16 nitehawk 50 49
c Remove include of db.h
cC
cK51303
e
s 00000/00000/00420
d D 1.48 00/03/07 11:48:10 nitehawk 49 48
c Turn on SCCS flag
cC
cK13562
cX0xa1
e
s 00000/00003/00420
d D 1.47 00/03/06 22:36:50 nitehawk 48 47
c DB is already initialized before calling rundaemon
cK52536
e
s 00003/00001/00420
d D 1.46 00/02/29 00:50:38 nitehawk 47 46
c Log nodeid as part of startup process
cC
cK63447
e
s 00001/00001/00420
d D 1.45 00/02/26 22:58:15 nitehawk 46 45
c uplinksendmessage needs messageid parameter
cC
cK58627
e
s 00006/00005/00415
d D 1.44 00/02/23 23:26:02 nitehawk 45 44
c Change direct malloc, realloc and free calls to use wrappers
cC
cK58503
e
s 00001/00001/00419
d D 1.43 00/02/20 19:59:50 nitehawk 44 43
c Additional parameter to dbfsmount
cC
cK53032
e
s 00005/00001/00415
d D 1.42 00/02/17 14:06:17 nitehawk 43 42
c Added call to mount root database
cC
cK52257
e
s 00006/00000/00410
d D 1.41 00/02/17 12:04:34 nitehawk 42 41
c Add call to buffer_isalinein to verify we have the entire
c input line before processing
cC
cK37522
e
s 00003/00002/00407
d D 1.40 00/02/15 12:32:10 nitehawk 41 40
c Filter NULL descriptors in loop
cC
cK29020
e
s 00011/00060/00398
d D 1.39 00/02/15 12:10:43 nitehawk 40 39
c Loop consolidation:  All secondary socket loops consolidated into
c a single pass.  Main game loop is now comprised of two secondary
c loops, one to load sockets into fdsets, another to process input
c post select.
cK26163
e
s 00000/00000/00458
d D 1.38 00/02/10 09:20:58 nitehawk 39 38
c Rename: src/client.c -> src/client/client.c
cC
cK13138
cPsrc/client/client.c
e
s 00003/00000/00455
d D 1.37 00/02/08 10:41:17 nitehawk 38 37
c Add call to netstartup
cC
cK38691
e
s 00009/00001/00446
d D 1.36 00/02/08 00:51:46 nitehawk 37 36
c Daemon function name setup for split binaries
c Added daemoninitstate to setup state variables according to daemon type
cK35264
e
s 00001/00001/00446
d D 1.35 00/02/05 23:12:22 nitehawk 36 35
c Fix log message at start of daemon loop
cC
cK22454
e
s 00002/00002/00445
d D 1.34 00/02/05 20:03:48 nitehawk 35 34
c All daemons use the same ticklength and reporting cycle variables
cC
cK22282
e
s 00021/00020/00426
d D 1.33 00/02/05 13:50:51 nitehawk 34 33
c Uplink messages are now received via input buffers
cC
cK20614
e
s 00044/00036/00402
d D 1.32 00/02/04 20:11:42 nitehawk 33 32
c Added support for live reboots
cC
cK11563
e
s 00001/00001/00437
d D 1.31 00/02/04 12:27:07 nitehawk 32 31
c Flush remainder of line from buffer upon receiving an
c unrecognized command
cC
cK60415
e
s 00001/00003/00437
d D 1.30 00/02/04 10:27:39 nitehawk 31 30
c confcreatelisten expects list pointer instead of descriptor
cC
cK58143
e
s 00005/00001/00435
d D 1.29 00/02/01 20:55:24 nitehawk 30 29
c Check for interrupted syscall in primary select
cC
cK63670
e
s 00001/00001/00435
d D 1.28 00/02/01 11:49:34 nitehawk 29 28
c Pass message data during disconnect
cC
cK59447
e
s 00031/00002/00405
d D 1.27 00/02/01 11:24:36 nitehawk 28 27
c Added handling for daemon shutdown
cK58987
e
s 00002/00002/00405
d D 1.26 00/01/31 23:48:21 nitehawk 27 26
c Change welcome message to include request for login
cC
cK61948
e
s 00047/00004/00360
d D 1.25 00/01/31 23:38:13 nitehawk 26 25
c Limit tick length in loop
c Add dispatcher to call out to the correct parser for the current state
cK61993
e
s 00092/00016/00272
d D 1.24 00/01/31 00:35:47 nitehawk 25 24
c Main command parser in place, use 'quit' to exit again
cC
cK25442
e
s 00005/00005/00283
d D 1.23 00/01/30 13:31:23 nitehawk 24 23
c updated to use new list data pointer union
cC
cK06959
e
s 00029/00023/00259
d D 1.22 00/01/29 23:47:25 nitehawk 23 22
c Add call to uplinkreceivemessage when an uplink is marked for read
cC
cK11054
e
s 00009/00005/00273
d D 1.21 00/01/29 13:12:39 nitehawk 22 21
c Don't put a socket in the out set if its buffer is empty
c Use the head of the list for node removal
cC
cK55268
e
s 00016/00018/00262
d D 1.20 00/01/25 23:36:30 nitehawk 21 20
c bail out when 'q' is received
cK47586
e
s 00046/00023/00234
d D 1.19 00/01/25 21:52:41 nitehawk 20 19
c Updated socket handling to use buffer code
cK43318
e
s 00001/00001/00256
d D 1.18 00/01/23 20:48:12 nitehawk 19 18
c Converting descriptor memory allocation to use new functions
cC
cK16659
e
s 00014/00001/00243
d D 1.17 00/01/21 21:11:03 nitehawk 18 17
c Added temporary code to close socket on receiving 'quit'
cK18785
e
s 00017/00004/00227
d D 1.16 00/01/20 21:34:19 nitehawk 17 16
c Added call to protocol negotiation
cC
cK60063
e
s 00001/00001/00230
d D 1.15 00/01/20 09:20:18 nitehawk 16 15
c Use status member to determine if a socket should be closed
cC
cK37158
e
s 00024/00002/00207
d D 1.14 00/01/19 23:23:41 nitehawk 15 14
c Added loop to close descriptors with close status
cK35877
e
s 00001/00001/00208
d D 1.13 00/01/19 23:08:31 nitehawk 14 13
c Daemon loop does not assume it has no connections if there
c are no uplinks
cK61216
e
s 00002/00000/00207
d D 1.12 00/01/19 23:06:33 nitehawk 13 12
c All connections to client daemon are PLAYER connections
c Reset counter of player sockets at beginning of loop
cK59738
e
s 00008/00004/00199
d D 1.11 00/01/17 23:00:16 nitehawk 12 11
c Added counter for player sockets for debug stats
cC
cK55510
e
s 00008/00001/00195
d D 1.10 00/01/17 22:52:24 nitehawk 11 10
c Added call to confcreateuplink in order to build uplinks
cK45789
e
s 00006/00001/00190
d D 1.9 00/01/16 19:03:54 nitehawk 10 9
c Inbound data mirrored back to socket
cC
cK31456
e
s 00147/00024/00044
d D 1.8 00/01/15 17:30:03 nitehawk 9 8
c New daemon loop for client daemon
cK22419
e
s 00002/00002/00066
d D 1.7 00/01/11 12:27:31 nitehawk 8 7
c Converted RCS tags to SCCS tags
cC
cK01708
e
s 00002/00007/00066
d D 1.6 00/01/09 17:59:45 nitehawk 7 6
c Remove pointer assignements for next and prev
cC
cK07855
e
s 00002/00001/00071
d D 1.5 00/01/01 16:56:51 nitehawk 6 5
c Change netlisten call to confcreatelisten -
c Use XML config file to open listen socket
cC
cK32633
e
s 00003/00002/00069
d D 1.4 00/01/01 12:59:06 nitehawk 5 4
c Change calls to uplink and listen to use port and address
cK32306
cZ-08:00
e
s 00009/00044/00062
d D 1.3 99/12/21 00:04:01 nitehawk 4 3
c Pruned out all non-client daemon code
cC
cK25339
e
s 00001/00001/00105
d D 1.2 99/12/20 22:59:25 nitehawk 3 2
c Change rundaemon to clientdaemon
cK24225
e
s 00106/00000/00000
d D 1.1 99/12/20 22:58:08 nitehawk 2 1
cF1
cK23927
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 99/12/20 22:58:08 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/src/koalamud/src/client.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK18889
cPsrc/client.c
cR6f32f5a9ab14de7f
cV3
cZ+00:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 8
/* $Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $ */
E 8
I 8
/* %Z% %M% %I% %Z% */
E 8
/***************************************************************\
D 15
*	Copyright (c) 1999 First Step Internet Services, Inc.
E 15
I 15
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
E 15
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

D 8
#define _KOALAMUD_CLIENT_C "$Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $"
E 8
I 8
#define _KOALAMUD_CLIENT_C "%Z% %K% %Z%"
E 8

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
I 6
#include "conf.h"
E 6
#include "log.h"
I 9
#include "memory.h"
#include "llist.h"
I 17
#include "uplinkprotocol.h"
I 20
#include "buffer.h"
I 25
#include "client.h"
#include "commands.h"
I 33
#include "reboot.h"
I 53
D 54
#include "parser.h"
E 54
I 54
#include "kparser.h"
E 54
E 53
I 43
D 50
#include "db.h"
E 50
E 43
E 33
E 25
E 20
E 17
E 9

D 3
koalaerror rundaemon(void)
E 3
I 3
D 37
koalaerror clientdaemon(void)
E 37
I 37
/* Initialize state variables */
koalaerror daemoninitstate(void)
{
I 55
	char cmdname[100] = "commands";
	commandentry cmd;

	cmd.next = NULL;
	cmd.command = cmdname;
	cmd.handler = do_commandlist;
	cmd.commandtype = CMD_GENERIC;
	cmd.numargs = 0;
	cmd.arglist = NULL;
	cmd.unlock = NULL;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "quit");
	cmd.handler = do_quit;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "reboot");
	cmd.handler = do_reboot;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "shutdown");
	cmd.handler = do_shutdown;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "memstat");
	cmd.handler = do_memstat;
	registercommand(&cmd, NULL);

D 56
	strcpy(cmdname, "loadmod");
	cmd.handler = do_loadmod;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "unloadmod");
	cmd.handler = do_unloadmod;
	registercommand(&cmd, NULL);

E 56
	strcpy(cmdname, "say");
	cmd.handler = do_say;
	registercommand(&cmd, NULL);
	strcpy(cmdname, "'");
	registercommand(&cmd, NULL);

	strcpy(cmdname, "who");
	cmd.handler = do_who;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "version");
	cmd.handler = do_version;
	registercommand(&cmd, NULL);

D 57
	strcpy(cmdname, "modlist");
	cmd.handler = do_modlist;
	registercommand(&cmd, NULL);

E 57
E 55
	koptions.daemontype = DAEMON_CLIENT;
I 55

E 55
	return KESUCCESS;
};

/* Startup the daemon */
koalaerror rundaemon(void)
E 37
E 3
{
I 9
	int selectreturn;
E 9
D 28
	bool running = TRUE;
E 28
D 7
	descriptor masterlisten = {NULL, NULL, 0, 0, {NULL}};
	descriptor uplinkconnection = {NULL, NULL, 0, 0, {NULL}};
E 7
I 7
D 9
	descriptor masterlisten = {0, 0, {NULL}};
	descriptor uplinkconnection = {0, 0, {NULL}};
E 7
	pdescriptor client = NULL;
	char welcome[] = "Welcome to KoalaMud.  This is early development"
		" code.  Please check back later.\n\r";
E 9
I 9
	pdescriptor desc = NULL;
	pdescriptor newdesc = NULL;
E 9
	koalaerror acceptreturn;
I 9
	listnodeptr desclist, tmplist;
	fd_set insockets, outsockets, errsockets;
D 51
	char logbuf[MAXLOGLINELEN];
E 51
I 21
D 25
	char inchar[2];
E 25
E 21
I 10
D 20
	char databuf[80];
	int readsize;
E 20
E 10
	int descriptorcount = 0;
	int numuplinks = 0;
I 12
	int numplayers = 0;
E 12
	int maxdescriptor = 0;
I 26
	unsigned long loopcount = 0;
	struct timeval waitcycle;
E 26
D 27
	char welcome[] = "Welcome to KoalaMud.  This is early development code."
			"  Please check back later.\n\r";
E 27
I 27
	char welcome[] = "Welcome to KoalaMud.  This is early development code.\r\n"
			"Please Enter your name:  ";
E 27

I 38
	/* Startup networking */
	netstartup();

E 38
D 43
	desclist = getdescriptorlist();
E 43
I 43
D 48
	/* Mount root of database - Client DB unlikely to have secondary mounts */
D 44
	dbfsmount(koptions.dbrootpath, NULL);
E 44
I 44
	dbfsmount(koptions.dbrootpath, NULL, MF_NORMAL);
E 44
E 43
D 19
	newdesc = (pdescriptor)malloc(sizeof(descriptor));
E 19
I 19
D 31
	newdesc = allocdescriptor();
E 19
	listaddnode(desclist, newdesc);
E 31
E 9

E 48
I 43
	/* Get master decriptor linked list */
	desclist = getdescriptorlist();
E 43
D 4
	if (netstartup() != KESUCCESS)
	{
		logerr("Error starting network, shutting down");
		return KENONETWORK;
	}

E 4
D 7
	masterlisten.next = masterlisten.prev = &masterlisten;
	uplinkconnection.next = uplinkconnection.prev = &uplinkconnection;

E 7
D 9
	/* Create uplink connection if server type is client */
D 4
	if (koptions.daemontype == DAEMON_CLIENT)
E 4
I 4
D 5
	if (netuplink(&uplinkconnection) < 0)
E 5
I 5
	if (netuplink(&uplinkconnection, koptions.uplinkopts.uplinkhost,
					koptions.uplinkopts.uplinkport) < 0)
E 9
I 9
	if (desclist == NULL)
E 9
E 5
E 4
	{
D 4
		if (netuplink(&uplinkconnection) < 0)
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
		masterlisten.next = masterlisten.prev = &masterlisten;
		uplinkconnection.next = uplinkconnection.prev = &masterlisten;
E 4
I 4
D 9
		logerr("Error starting network interface, shutting down");
		return KENONETWORK;
E 9
I 9
D 52
		logerr("Unable to create descriptor linked list - bail out");
E 52
I 52
		logmsg(LOGCRIT, "Unable to create descriptor linked list - bail out");
E 52
		return KENOMEM;
E 9
E 4
	}
I 4
D 7
	masterlisten.next = masterlisten.prev = &masterlisten;
	uplinkconnection.next = uplinkconnection.prev = &masterlisten;
E 7
E 4

D 4
	/* If we are setting up a zone server, we should connect to a hub
	 * server if the uplink is defined, otherwise, start listening on the
	 * uplink port */
	if (koptions.daemontype == DAEMON_ZONE)
	{
		if (koptions.uplinkopts.uplinkopt)
		{
			if (netuplink(&uplinkconnection) < 0)
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
		}
		else
		{
			if (netlisten(&masterlisten, koptions.port) < 0)
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
		}
	}
	else
E 4
I 4
D 9
	/* Start up listen socket */
D 5
	if (netlisten(&masterlisten, koptions.port) < 0)
E 5
I 5
D 6
	if (netlisten(&masterlisten, NULL, koptions.port) < 0)
E 6
I 6
	if (confcreatelisten(&masterlisten) < 0)
E 9
I 9
D 11
	/* Start listening for uplink connections */
E 11
I 11
D 33
	/* Attempt to create an uplink */
	if (confcreateuplink(desclist) != KESUCCESS)
E 33
I 33
	/* check to see if this was a reboot */
	if (!(kstate.running == DSTATE_REBOOTING &&
				(reloaddescriptors() == KESUCCESS)))
E 33
	{
D 33
		logerr("Error connecting to uplink, use 'link' as an admin to create"
				"an uplink");
	}
E 33
I 33
		/* Attempt to create an uplink */
		if (confcreateuplink(desclist) != KESUCCESS)
		{
D 52
			logerr("Error connecting to uplink, use 'link' as an admin to"
					" create an uplink");
E 52
I 52
			logmsg(LOGWARN, "Error connecting to uplink, use 'link' as an"
					" admin to create an uplink");
E 52
		}
E 33

D 33
	/* Start listening for player connections */
E 11
D 31
	if (confcreatelisten(newdesc) < 0)
E 31
I 31
	if (confcreatelisten(desclist) < 0)
E 31
E 9
E 6
E 5
E 4
	{
D 4
		/* we are starting either a hub server or a client server,
		 * either way, we need a listen socket */
		if (netlisten(&masterlisten, koptions.port) < 0)
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
E 4
I 4
		logerr("Error starting network interface, shutting down");
		return KENONETWORK;
E 33
I 33
		/* Start listening for player connections */
		if (confcreatelisten(desclist) < 0)
		{
D 52
			logerr("Error starting network interface, shutting down");
E 52
I 52
			logmsg(LOGCRIT, "Error starting network interface, shutting down");
E 52
			return KENONETWORK;
		}
E 33
E 4
	}

I 9
D 36
	logmsg("Starting main hub routing loop");
E 36
I 36
D 47
	logmsg("Starting main client daemon loop");
E 47
I 47
D 51
	sprintf(logbuf, "Starting main client daemon loop on node ID: %x",
E 51
I 51
	logmsg(LOGINFO, "Starting main client daemon loop on node ID: %x",
E 51
			kstate.nodeid);
D 51
	logmsg(logbuf);
E 51
E 47
E 36
E 9
D 28
	while (running)
E 28
I 28
D 33
	while (kstate.running)
E 33
I 33
	while (kstate.running == DSTATE_RUNNING)
E 33
E 28
	{
D 9
		acceptreturn = netaccept(&masterlisten, &client);
		if (acceptreturn == KENOMEM)
E 9
I 9
		descriptorcount = 0;
		numuplinks = 0;
		maxdescriptor = 0;
I 13
		numplayers = 0;
E 13
		FD_ZERO(&insockets);
		FD_ZERO(&outsockets);
		FD_ZERO(&errsockets);

		for(tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 24
			desc = (pdescriptor)tmplist->data;
E 24
I 24
			desc = tmplist->data.desc;
E 24

			// Filter dummy sockets
D 22
			if (desc->type == DESCRIPTOR_DUMMY)
E 22
I 22
			if (desc->type == DESCRIPTOR_DUMMY || desc->status > STATUS_NOMINAL)
E 22
			{
				continue;
			}
			
			// Add descriptor to select sets
			if (desc->type != DESCRIPTOR_LISTEN)
			{
D 12
				numuplinks++;
E 12
I 12
				if (desc->type == DESCRIPTOR_PLAYER)
I 20
				{
D 22
					FD_SET(desc->socket, &outsockets);
E 22
I 22
					if (!buffer_outbufempty(desc))
					{
						FD_SET(desc->socket, &outsockets);
					}
E 22
E 20
					numplayers++;
I 20
				}
E 20
				else
I 20
				{
E 20
					numuplinks++;
I 20
				}
E 20
E 12
				FD_SET(desc->socket, &errsockets);
D 20
				FD_SET(desc->socket, &outsockets);
E 20
			}
			FD_SET(desc->socket, &insockets);
			descriptorcount++;

			maxdescriptor = (maxdescriptor > desc->socket) ?
				maxdescriptor : desc->socket;
		}

D 26
		snprintf(logbuf, MAXLOGLINELEN,
E 26
I 26
		/* Have we reached the reporting period */
D 35
		if (((loopcount++) % CLIENTREPORTPERIOD) == 0)
E 35
I 35
		if (((loopcount++) % koptions.reportingperiod) == 0)
E 35
		{
D 51
			snprintf(logbuf, MAXLOGLINELEN,
E 51
I 51
			logmsg(LOGINFO,
E 51
E 26
D 12
				"%d descriptors, %d Listen, %d Uplink, Max FD=%d",
				descriptorcount, (descriptorcount - numuplinks), (numuplinks),
				maxdescriptor);
E 12
I 12
				"%d descriptors, %d Listen, %d Uplink, %d player, Max FD=%d",
				descriptorcount, (descriptorcount - numuplinks - numplayers),
				(numuplinks), (numplayers), maxdescriptor);
E 12
D 26
		logdbg(logbuf);
E 26
I 26
D 51
			logdbg(logbuf);
E 51
		}
E 26
D 14
		if (numuplinks == 0)
E 14
I 14
		if (numuplinks == 0 && numplayers == 0)
E 14
E 9
		{
D 9
			close(masterlisten.socket);
			return KENOMEM;
E 9
I 9
D 51
			logmsg("No Connections, sleeping");
E 51
I 51
			logmsg(LOGINFO, "No Connections, sleeping");
E 51

			if ((selectreturn = select(maxdescriptor + 1, &insockets,
						NULL, NULL, NULL)) < 0)
			{
				if (errno == EINTR)
				{
D 51
					logmsg("Waking up to process signal");
E 51
I 51
					logmsg(LOGINFO, "Waking up to process signal");
E 51
				}
				else
				{
D 52
					logerr("Problems with select - bailing water");
E 52
I 52
					logmsg(LOGERR, "Problems with select - bailing water");
E 52
					continue;
				}
			}
			else
			{
D 40
				logmsg("New uplink in progress - Waking to process");
E 40
I 40
D 51
				logmsg("New connection in progress - Waking to process");
E 51
I 51
				logmsg(LOGINFO, "New connection in progress -"
						" Waking to process");
E 51
E 40
			}
		}

I 26
		/* Setup wait cycle */
		waitcycle.tv_sec = 0;
D 35
		waitcycle.tv_usec = MAXCLIENTTICKLEN;
E 35
I 35
		waitcycle.tv_usec = koptions.ticklen;
E 35
	
E 26
		// Block progress until there is data on a socket
		// 	Since this is a hub, we don't need to worry about timing :)
		if ((selectreturn = select(maxdescriptor + 1, &insockets,
D 20
			NULL, &errsockets, NULL)) < 0)
E 20
I 20
D 26
			&outsockets, &errsockets, NULL)) < 0)
E 26
I 26
			&outsockets, &errsockets, &waitcycle)) < 0)
E 26
E 20
		{
D 22
			logerr("Main hub routing loop dead - falling out");
E 22
I 22
D 30
			perror("select fail:");
E 30
I 30
			if (errno == EINTR)
			{
D 51
				logmsg("Waking up to process signal");
E 51
I 51
				logmsg(LOGINFO, "Waking up to process signal");
E 51
				continue;
			}
E 30
D 52
			logerr("Main client loop dead - falling out");
E 52
I 52
			logmsg(LOGCRIT, "Main client loop dead - falling out");
E 52
E 22
			return KESELECTFAIL;
E 9
		}
D 9
		if (acceptreturn == KENOACCEPT)
E 9
I 9
		
I 15
D 40
		/* Close descriptors marked to be closed */
E 40
I 40
		/* Loop through descriptors and take appropriate action */
E 40
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 24
			desc = (pdescriptor)tmplist->data;
E 24
I 24
			desc = tmplist->data.desc;
E 24

D 41
			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
E 41
I 41
			/* Filter out invalid descriptors */
			if (desc->type == DESCRIPTOR_DUMMY
					|| desc->type == DESCRIPTOR_NULL)
E 41
			{
				continue;
			}

I 40
			/* First we check for descriptors to close */
E 40
			/* Is this descriptor marked for closure */
D 16
			if (desc->close)
E 16
I 16
D 40
			if (desc->status == STATUS_CLOSE)
E 40
I 40
			if (desc->status == STATUS_CLOSE ||
					FD_ISSET(desc->socket, &errsockets))
E 40
E 16
			{
				tmplist = listprevnode(tmplist);
D 22
				listremovenode(tmplist, desc);
E 22
I 22
				listremovenode(desclist, desc);
E 22
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
I 58
				kmfree(desc->data.character->name, ALLOC_DESCRIPTOR);
				kmfree(desc->data.character, ALLOC_DESCRIPTOR);
E 58
				netclose(desc);
I 58
				continue;
E 58
			}
D 40
		}

E 15
		/* Close Sockets in error set */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
E 9
		{
D 9
			/* Probaly just no connections waiting
			 * 	shouldn't get this in normal operations */
			logdbg("No connections waiting");
			continue;
E 9
I 9
D 24
			desc = (pdescriptor)tmplist->data;
E 24
I 24
			desc = tmplist->data.desc;
E 24

			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}
D 15
			
E 15
I 15

E 15
			/* If this descriptor has an error on it: */
			if (FD_ISSET(desc->socket, &errsockets))
			{
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
				tmplist = listprevnode(tmplist);
				listremovenode(desclist, desc);
				netclose(desc);
			}
E 9
		}

I 20
		/* Write data to sockets in the output set */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 24
			desc = (pdescriptor)tmplist->data;
E 24
I 24
			desc = tmplist->data.desc;
E 40
E 24

D 40
			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}

			/* If this descriptor has room to write data to it: */
E 40
I 40
			/* Flush a chunk of the output buffer */
E 40
			if (FD_ISSET(desc->socket, &outsockets))
			{
				buffer_sendbytes(desc, MAXWRITESIZE);
			}
D 40
		}

E 20
D 9
		netwrite(client, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
		netwrite(client, welcome, strlen(welcome));
E 9
I 9
D 10
		/* Handle new connections and route inbound data around the network */
E 10
I 10
		/* Handle new connections and handle inbound commands */
E 10
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 24
			desc = (pdescriptor)tmplist->data;
E 24
I 24
			desc = tmplist->data.desc;
E 24

			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}
E 40

D 40
			/* Is there data on the socket */
E 40
I 40
			/* Handle sockets on the input set */
E 40
			if (FD_ISSET(desc->socket, &insockets))
			{
				/* Are we a listener? */
				if (desc->type == DESCRIPTOR_LISTEN)
				{
					acceptreturn = netaccept(desc, &newdesc);
					if (acceptreturn == KENOMEM)
					{
						return KENOMEM;
					}
					if (acceptreturn == KENOACCEPT)
					{
						/* Probaly just no connections waiting
						 * 	shouldn't get this in normal operations */
D 52
						logdbg("No connections waiting");
E 52
I 52
						logmsg(LOGWARN, "No connections waiting");
E 52
						continue;
					}
I 13
					newdesc->type = DESCRIPTOR_PLAYER;
I 17
					newdesc->status = STATUS_NOMINAL;
I 26
					/* Allocate memory for the player information */
D 45
					newdesc->data.character = malloc(sizeof(character));
E 45
I 45
					newdesc->data.character = kmalloc(sizeof(character),
							ALLOC_DESCRIPTOR);
E 45
					if (newdesc->data.character == NULL)
					{
D 52
						logerr("unable to allocate memory for character data");
E 52
I 52
						logmsg(LOGCRIT, "unable to allocate memory for"
								" character data");
E 52
						netclose(newdesc);
						continue;
					}
					bzero(newdesc->data.character, sizeof(character));
					newdesc->data.character->desc = newdesc;
E 26
E 17
E 13
D 20
					netwrite(newdesc, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
					netwrite(newdesc, welcome, strlen(welcome));
E 20
I 20
					buffer_queue(newdesc, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
					buffer_queue(newdesc, welcome, strlen(welcome));
E 20
					listaddnode(desclist, newdesc);
D 34
				}
I 23
				else if (desc->type == DESCRIPTOR_UNKNOWN &&
							desc->status < STATUS_NOMINAL)
				{
					/* This is an uplink, but we don't know what type yet
					 * - Handle protocol negotiation
					 */
					uplinknegotiatestage(desc);
				}
				/* We can't uplink to a client server */
				else if (desc->type >= DESCRIPTOR_HUBSRV &&
						desc->type <= DESCRIPTOR_ZONESRV &&
						desc->status == STATUS_NOMINAL)
				{
					/* If we have input on an uplink, pass it off to
					 * uplinkreceivemessage
					 */
					uplinkreceivemessage(desc);
				}
E 34
I 34
				} /* if Listener */
E 34
E 23
				else
D 34
				{
E 34
I 34
				{	 /* Otherwise we just read data into the buffer */
E 34
D 17
					/* Read data and route it to appropriate server */
I 10
					readsize = 80;
					netread(desc, databuf, &readsize);
					netwrite(desc, databuf, readsize);
E 17
I 17
D 23
					if (desc->type == DESCRIPTOR_UNKNOWN &&
							desc->status < STATUS_NOMINAL)
E 23
I 23
					buffer_receive(desc);
D 25
					if ((inchar[0] = buffer_readchar(desc)) == 'q')
E 23
					{
D 23
						/* This is an uplink, but we don't know what type yet
						 * - Handle protocol negotiation
						 */
						uplinknegotiatestage(desc);
E 23
I 23
						buffer_queue(desc, "GoodBye\r\n",
								strlen("GoodBye\r\n"));
						desc->status = STATUS_CLOSE;
						tmplist = listprevnode(tmplist);
						listremovenode(desclist, desc);
						/* Make sure the out buffer is empty */
						buffer_sendbytes(desc, OUTRINGSIZE);
						netclose(desc);
E 23
					}
					else
					{
D 20
						/* Read data and route it to appropriate server */
						readsize = 80;
						netread(desc, databuf, &readsize);
D 18
						netwrite(desc, databuf, readsize);
E 18
I 18
						/* If the user typed 'quit', mark the socket for
						 * closer and say good bye */
						if (strncasecmp(databuf, "quit", 4) == 0)
						{
							netwrite(desc, "GoodBye\r\n", 9);
							desc->status = STATUS_CLOSE;
							tmplist = listprevnode(tmplist);
							listremovenode(tmplist, desc);
							netclose(desc);
						}
						else
						{
							netwrite(desc, databuf, readsize);
						}
E 20
I 20
D 23
						buffer_receive(desc);
I 21
						if ((inchar[0] = buffer_readchar(desc)) == 'q')
						{
							buffer_queue(desc, "GoodBye\r\n",
									strlen("GoodBye\r\n"));
							desc->status = STATUS_CLOSE;
							tmplist = listprevnode(tmplist);
D 22
							listremovenode(tmplist, desc);
E 22
I 22
							listremovenode(desclist, desc);
E 22
							/* Make sure the out buffer is empty */
							buffer_sendbytes(desc, OUTRINGSIZE);
							netclose(desc);
						}
						else
						{
							buffer_queue(desc, inchar, 1);
						}
E 23
I 23
						buffer_queue(desc, inchar, 1);
E 23
E 21
E 20
E 18
					}
E 25
E 17
E 10
				}
D 40
			}
		}
I 25

		/* Loop through descriptors and parse input */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;
E 40
I 40
			} // Marked for read?
E 40

I 40
			/* Parse input and uplink commands */
E 40
			if (desc->type == DESCRIPTOR_PLAYER)
			{
I 34
				/* Players use the client dispatcher */
E 34
D 26
				clientparsecommand(desc);
E 26
I 26
				clientdispatcher(desc);
I 34
			}
			else if (desc->type == DESCRIPTOR_UNKNOWN &&
						desc->status < STATUS_NOMINAL)
			{
				/* This is an uplink, but we don't know what type yet
				 * - Handle protocol negotiation
				 */
				uplinknegotiatestage(desc);
			}
			/* We can't uplink to a client server */
			else if (desc->type >= DESCRIPTOR_HUBSRV &&
					desc->type <= DESCRIPTOR_ZONESRV &&
					desc->status == STATUS_NOMINAL)
			{
				/* If we have input on an uplink, pass it off to
				 * uplinkreceivemessage
				 */
				uplinkreceivemessage(desc);
E 34
E 26
			}
I 28
D 40
		}
	}
E 40
I 40
		}	// Descriptor Loop
	}	// Main game loop
E 40

D 33
	/* If we get here, we were told to shutdown the system, scan through the
	 * descriptor list and send a 'goodbye' message to all players and a
	 * disconnect message to all uplinks */
	for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
E 33
I 33
	if (kstate.running == DSTATE_SHUTDOWN)
E 33
	{
D 33
		char goodbye[] = "Server is shutting down, come back later\r\n";
		message_data msgdata;
		msgdata.data = NULL;

		desc = tmplist->data.desc;
		
		switch (desc->type)
E 33
I 33
		/* If we get here, we were told to shutdown the system, scan through the
		 * descriptor list and send a 'goodbye' message to all players and a
		 * disconnect message to all uplinks */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
E 33
		{
D 33
			case DESCRIPTOR_PLAYER:
				/* Its a player - Send a goodbye message */
				netwrite(desc, goodbye, strlen(goodbye));
				break;

			case DESCRIPTOR_HUBSRV:
			case DESCRIPTOR_CLIENTSRV:
			case DESCRIPTOR_ZONESRV:
				/* Its an uplink - send a disconnect message */
D 29
				uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, NULL);
E 29
I 29
				uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata);
E 29
				break;
E 33
I 33
			char goodbye[] = "Server is shutting down, come back later\r\n";
			message_data msgdata;
			msgdata.data = NULL;
E 33

D 33
			default:
				continue;
E 33
I 33
			desc = tmplist->data.desc;
			
			switch (desc->type)
			{
				case DESCRIPTOR_PLAYER:
					/* Its a player - Send a goodbye message */
					netwrite(desc, goodbye, strlen(goodbye));
					break;

				case DESCRIPTOR_HUBSRV:
				case DESCRIPTOR_CLIENTSRV:
				case DESCRIPTOR_ZONESRV:
					/* Its an uplink - send a disconnect message */
D 46
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata);
E 46
I 46
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata, 0);
E 46
					break;

				default:
					continue;
			}
E 33
E 28
		}
E 25
E 9
D 23

E 23
D 9
		netclose(client);
E 9
	}
D 33
	
E 33
I 25
D 53
	return KESUCCESS;
}

/* clientparsecommand - Read a word from the buffer and parse it into a
 * command.  Send UNKNOWNCOMMANDREPONSE if no match for the input is found
 */
koalaerror clientparsecommand(pdescriptor desc)
{
	char *wordbuf = NULL;
	char *wordcur = NULL;
	int wordlen = WORDLENSTEP;
	koalaerror kerr;
	int charnum;	// Used as an index into the command table
	int x;

I 42
	/* verify that the client has a line of input */
	if (!buffer_isalinein(desc))
	{
		return KESUCCESS;
	}

E 42
	/* Allocate memory to read a word from the buffer */
D 45
	wordbuf = malloc(sizeof(char) * WORDLENSTEP);
E 45
I 45
	wordbuf = kmalloc(sizeof(char) * WORDLENSTEP, ALLOC_TEMP);
E 45
	if (wordbuf == NULL)
	{
D 52
		logerr("Unable to allocate memory for word buffer");
E 52
I 52
		logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
E 52
		return KENOMEM;
	}
	wordcur = wordbuf;

	/* Get a word from the buffer */
	while ((kerr = buffer_readword(desc, wordcur, WORDLENSTEP)) == KENOMEM)
	{
D 45
		wordcur = realloc(wordbuf, wordlen + WORDLENSTEP);
E 45
I 45
		wordcur = krealloc(wordbuf, wordlen + WORDLENSTEP, ALLOC_TEMP);
E 45
		if (wordcur == NULL)
		{
D 52
			logerr("Unable to allocate memory for word buffer");
E 52
I 52
			logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
E 52
			return KENOMEM;
		}
		wordbuf = wordcur;
		wordcur = wordbuf + wordlen;
		wordlen += WORDLENSTEP;
	}
	if (kerr == KENOTENOUGH)
	{
		/* There wasn't any data buffered.  Return success, even though we
		 * didn't do anything */
D 45
		free(wordbuf);
E 45
I 45
		kmfree(wordbuf, ALLOC_TEMP);
E 45
		return KESUCCESS;
	}

	/* At this point we know we have a word from the buffer, now we need to
	 * find the command that the user specified */
	charnum = toupper(wordbuf[0]) - 'A';
	/* If it isn't in bounds, set charnum to 26, table 26 contains commands
	 * starting with special symbols */
	if (charnum < 0 || charnum > 25)
	{
		charnum = 26;
	}

	for(x = 0; commandtable[charnum][x].command; x++)
	{
		if (strcasecmp(wordbuf, commandtable[charnum][x].command) == 0)
		{
			/* we have a match.  If the handler is not null, call it */
			if (commandtable[charnum][x].handler)
			{
				commandtable[charnum][x].handler(desc);
			}
			break;
		}
	}

	if (commandtable[charnum][x].command == NULL)
	{
		/* No match was found */
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
D 32

E 32
I 32
		buffer_flushline(desc);
E 32
	}

	/* Free memory used by word buffer */
D 45
	free(wordbuf);
E 45
I 45
	kmfree(wordbuf, ALLOC_TEMP);
E 45
I 26

E 53
	return KESUCCESS;
}

/* clientdispatcher - This function calls the appropriate parser for the
 * current player state */
koalaerror clientdispatcher(pdescriptor desc)
{
	/* Make sure we were given 'desc' and that it is a player descriptor */
	if (!desc || desc->type != DESCRIPTOR_PLAYER || !desc->data.character)
	{
D 52
		logerr("Caught invalid descriptor in dispatcher");
E 52
I 52
		logmsg(LOGWARN, "Caught invalid descriptor in dispatcher");
E 52
		return KEMISSINGARG;
	}

	/* We have a valid descriptor, dispatch input to the currect parser */
	switch (desc->data.character->state)
	{
		case STATE_GETNAME:
			return clientgetname(desc);
		case STATE_PLAYING:
D 55
			return clientparsecommand(desc);
E 55
I 55
			//return clientparsecommand(desc);
			return commandparser(desc);
E 55
	}
E 26

E 25
	return KESUCCESS;
}
I 20
D 21


/* If the user typed 'quit', mark the socket for
 * closer and say good bye */
/*
if (strncasecmp(databuf, "quit", 4) == 0)
{
	netwrite(desc, "GoodBye\r\n", 9);
	desc->status = STATUS_CLOSE;
	tmplist = listprevnode(tmplist);
	listremovenode(tmplist, desc);
	netclose(desc);
}
else
{
	netwrite(desc, databuf, readsize);
}
*/
E 21
E 20
E 2
I 1
E 1
