h40234
s 00000/00000/00075
d D 1.8 00/03/07 18:09:01 nitehawk 9 8
c Delete: include/lib/dnode.h
cC
cK05444
cPBitKeeper/deleted/.del-dnode.h
e
s 00000/00000/00075
d D 1.7 00/03/07 11:48:09 nitehawk 8 7
c Turn on SCCS flag
cC
cK29943
cX0xa1
e
s 00000/00000/00075
d D 1.6 00/02/19 17:47:23 nitehawk 7 6
c Rename: lib/include/dnode.h -> include/lib/dnode.h
cC
cK25144
cPinclude/lib/dnode.h
e
s 00008/00003/00067
d D 1.5 00/02/18 10:06:19 nitehawk 6 5
c Added additional special dnode type.  Explained special
c dnodes better
cC
cK21113
e
s 00046/00012/00024
d D 1.4 00/02/17 00:14:39 nitehawk 5 4
c dnode structure finished up
cC
cK56899
e
s 00000/00000/00036
d D 1.3 00/02/15 18:51:16 nitehawk 4 3
c Rename: lib/include/dbtree.h -> lib/include/dnode.h
cK02004
cPlib/include/dnode.h
e
s 00024/00000/00012
d D 1.2 00/02/15 17:08:33 nitehawk 3 2
c First pieces of Dnode structure added
cC
cK21426
e
s 00012/00000/00000
d D 1.1 00/02/14 19:26:08 nitehawk 2 1
cF1
cK20509
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/14 19:26:08 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/include/dbtree.h
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK49733
cPlib/include/dbtree.h
cR280ec362c9896ce4
cV2
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
D 5
*	Module: dbtree
E 5
I 5
*	Module: db
E 5
\***************************************************************/

D 5
#ifndef _KOALAMUD_LIB_DBTREE_H
#define _KOALAMUD_LIB_DBTREE_H "%Z% %K% %Z%"
E 5
I 5
#ifndef _KOALAMUD_LIB_DNODE_H
#define _KOALAMUD_LIB_DNODE_H "%Z% %K% %Z%"

/* We need fstypes.h for generic file system types */
#include "fstypes.h"
E 5

I 3
/*	These structures are all for the on disk database file.  */
I 5
/* Number of direct blocks */
#define KDADDR	12
E 5

D 5
/* This type is to ensure that all references to dnodes are consistant */
typedef kdbfs_dnode_t	u_int32_t;
E 5
I 5
/*  of indirect blocks */
#define KIADDR	3
E 5

/*	TAG_DNODE
 *		This is a database node.  All database entries are instances of this
 *		structure.
 *		Note: This structure is very similar to the inode structure of UFS.
 *		Major differences are:
D 5
 *			Only one time counter - last used
E 5
 *			Shorter block lists since most objects are not going to be more
 *				then three or four blocks in size.
 *			'owner' and 'group' are dnode numbers
 */
D 5


E 5
typedef struct TAG_DNODE
{
D 5
	kdbfs_dnode_t	dnum;	/* 0: dnode number, keep for consistancy checking */
	kdbfs_dnode_t	duid;	/* 4: Pointer to object owner */
	kdbfs_dnode_t	dgid;	/* 8: Pointer to object group */
} dnode;
E 5
I 5
	kdbfs_dnode_t	d_num;	/* 0: dnode number, keep for consistancy checking */
	kdbfs_dnode_t	d_uid;	/* 4: Pointer to object owner */
	kdbfs_dnode_t	d_gid;	/* 8: Pointer to object group */
	int32_t			d_ctime;	/* 12: Object creation time */
	int32_t			d_ctimesec;	/* 16: Object creation time */
	int32_t			d_atime;	/* 20: Last object access time */
	int32_t			d_atimesec;	/* 24: Last object access time */
	int32_t			d_mtime;	/* 28: Object modification time */
	int32_t			d_mtimesec;	/* 32: Object modification time */
	u_int16_t		d_links;	/* 36: Link counter */
	u_int64_t		d_size;		/* 38: Total object size */
	u_int32_t		d_blocks;	/* 46: Held Block count */
	u_int32_t		d_flags;	/* 50: Object flags. */
	u_int8_t		d_nodetype;		/* 54: Node type: see below */

	u_int8_t		d_spare[11];	/* 55: Reserved; currently unused */

	kdbfs_blockid_t	d_db[KDADDR];	/* 68: Direct disk blocks - 48 */
	kdbfs_blockid_t	d_ib[KIADDR];	/* 116: Indirect disk blocks - 12 */
} dnode;  /* Total size: 128 bytes */

/* Node type flags */
#define DNTYPE_FREE			0x0
#define DNTYPE_SYMLINK		0x1
#define DNTYPE_DIRECTORY	0x2
#define DNTYPE_OBJECT		0x3
#define DNTYPE_SHORTSYM		0x4

/* Short symlinks use the disk block fields to store the target path, this
 * saves allocation of a disk block for the target path
 */
#define MAXSSYMLEN ((KDADDR + KIADDR) * sizeof(kdbfs_blockid_t))

D 6
/* Special dnode numbers */
#define DNODE_ROOT		((kdbfs_blockid_t) 0)
#define DNODE_ROOTOWN	((kdbfs_blockid_t) 1)  // /players/root
E 6
I 6
/* Special dnode numbers
 * 	Note: the Players tree does not *really* need special meaning.  It is
 * 	only specified to make new database creation easier.  /players/ and
 * 	/players/root/ will only exist on the root filesystem.  On other
 * 	filesystems, their respective dnodes can be used by other objects */
#define DNODE_ROOT		((kdbfs_blockid_t) 0)	// /
#define DNODE_PLAYERS	((kdbfs_blockid_t) 1)	// /players/
#define DNODE_ROOTOWN	((kdbfs_blockid_t) 2)	// /players/root
E 6
E 5

E 3
#endif
E 2
I 1
E 1
