// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.17 $
#ifndef KNODAMAINDOCKWINDOWBASE_H
#define KNODAMAINDOCKWINDOWBASE_H
#include <kdockwidget.h>
#include <kmdimainfrm.h>
#include <kparts/partmanager.h>
#include <hk_dsvisible.h>
#include <hk_string.h>
#include <qstring.h>

 
const QString autoform="Autoform";

 
 typedef class struct_commands
{
 public:
 bool p_showlistwindow;
 struct_commands()
 {
   p_showlistwindow=true;
 }
};


class knodamaindockwindowbaseprivate;
class hk_kdedblistview;
class hk_connection;
class hk_database;
class QListViewItem;
class QToolButton;

class knodamaindockwindowbase : public KMdiMainFrm, public hk_dsvisible
{
Q_OBJECT
public:
knodamaindockwindowbase(struct_commandlinefields* commandline=NULL,QWidget* parent=0L,const char* name=0L, WFlags f=WType_TopLevel|WDestructiveClose,
			const QString& dbname="",const QString& form="");

virtual ~knodamaindockwindowbase();
hk_connection* connection(void);
void set_connection(hk_connection*);
void set_drivername(const hk_string&);
public slots:
void slot_database_selected(int);
 virtual void slot_new_database(void){}
 virtual void slot_delete_database(const QString&){}
 
 virtual void slot_new_table(void){}
 virtual void slot_delete_table(const QString&){}
 virtual void slot_designmode_table(const QString&){}
 virtual void slot_viewmode_table(const QString&){}

 virtual void slot_new_query(void){}
 virtual void slot_delete_query(const QString&){}
 virtual void slot_designmode_query(const QString&){}
 virtual void slot_viewmode_query(const QString&){}

 virtual void slot_new_view(void){}
 virtual void slot_delete_view(const QString&){}
 virtual void slot_designmode_view(const QString&){}
 virtual void slot_viewmode_view(const QString&){}

 virtual void slot_new_form(void){}
 virtual void slot_delete_form(const QString&){}
 virtual void slot_designmode_form(const QString&){}
 virtual void slot_viewmode_form(const QString&){}

 virtual void slot_new_report(void){}
 virtual void slot_delete_report(const QString&){}
 virtual void slot_designmode_report(const QString&){}
 virtual void slot_viewmode_report(const QString&){}
 virtual void newwindow_clicked(){}
virtual void rename_clicked(){}
virtual void importcsv_clicked(){}
virtual void exportcsv_clicked(){}
virtual void exportxml_clicked(){}
virtual void newpassworddialog_selected(void){}
virtual void copy_clicked(void){}
virtual void paste_clicked(void){}
virtual void clipboarddata_has_changed(void){}
virtual void databasesettings_clicked(void) {}
virtual void objecthandler_clicked(void) {}
virtual void slot_listbox_popup(QListViewItem*,const QPoint&){}
virtual void settings_clicked(void){}
virtual void show_drivers(){}
virtual void slot_closewindow();
void slot_activate_closeaction();
void set_databases(void);
void driver_selected(int);
void slot_disconnect(void);
void slot_open_localdatabase();

 
 
protected:
virtual void closeEvent(QCloseEvent*);

KWidgetAction*    p_databaseaction; 
KComboBox*        p_databasecombobox;
KAction*          p_closeaction;
KAction*          p_quitaction;

KActionMenu* p_newobjectaction;
KActionMenu* p_newconnectionaction;
KActionMenu* p_displaymodeaction;
KRadioAction* p_idealmodeaction;
KRadioAction* p_tabpagemodeaction;
KRadioAction* p_childframemodeaction;
//KRadioAction* p_toplevelmodeaction;


KAction* p_disconnectaction;
KAction* p_newdatabaseaction;

KAction* p_newtableaction;
KAction* p_newqueryaction;
KAction* p_newviewaction;
KAction* p_newformaction;
KAction* p_newreportaction;
KAction* p_newaction;
KAction* p_alteraction;
KAction* p_startaction;
KAction* p_deleteaction;
KAction* p_copyaction;
KAction* p_pasteaction;
KAction* p_renameaction;
KActionMenu* p_exportaction;
KAction* p_exportcsvaction;
KAction* p_exportxmlaction;
KActionMenu* p_importaction;
KAction* p_importcsvaction;
KAction* p_passwordaction;
KAction* p_databasesettingaction;
KAction* p_objecthandleraction;
KAction* p_newwindowaction;
KAction* p_settingsaction;
KAction* p_openlocaldbaction;
QToolButton* newbutton;
QToolButton* alterbutton;
QToolButton* startbutton;
QToolButton* deletebutton;

hk_kdedblistview* p_listview;
hk_database*      p_database;
hk_connection*    p_connection;
KParts::PartManager* p_partmanager;

private:
void internal_set_database(const hk_string&);
knodamaindockwindowbaseprivate* p_private;
};


#endif //KNODAMAINDOCKWINDOWBASE_H
