/***************************************************************************
                      challenge_graph.h  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2003 by Eric Faccer
    email                : e.faccer@qut.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHALLENGE_GRAPH_H
#define CHALLENGE_GRAPH_H

#include <qstringlist.h>
#include <qvbox.h>
#include <qevent.h>
#include <qcolor.h>

#include "resource.h"
#include "challenge_game.h"

class KPopupMenu;
class QCanvas;
class QLabel;
class Challenge_Graph_View;
class Command;

class Challenge_Graph : public QVBox
{
	Q_OBJECT

	public:
										Challenge_Graph(QWidget *parent=0, const char *name=0, resource *Rsrc=0);
		virtual					~Challenge_Graph();
		void						resizeEvent( QResizeEvent* );
		void						add( Challenge_Game *seek );
		void						clear();

	signals:
		void						sendCMD( const Command& );

	public slots:
		void						recvCMD( const Command& );
		void						display_menuSeek( Challenge_Game*, const QPoint& );
		void						selectMatch( int );
		void						menuFunct( int );

	protected:
		virtual bool		isEmpty( int x, int y );
		void						drawChallenge( int time_control_x, int rating_y, bool rated, Challenge_Game *challenge );
		bool						addTo_Nearest_Neighbour( int orig_x, int orig_y, bool rated, Challenge_Game *challenge, int searchdepth=10 );
		void						createBackground( void );
		void						addSoughtItem( const QString& );
		void						updateSoughtList( void );

	private:
		int x_size;
		int y_size;
		int max_rating;
		int max_time;
		bool seek;

		resource							*myResource;
		QCanvas								*graph;
		Challenge_Graph_View	*myView;
		QLabel								*myStatusBar;
		QPixmap								background;

		KPopupMenu			*menuSeek;
		int							selectedMatchID;
		QString					selectedPlayerName;
		/*
				These StringLists temporarily store Sought Game data
				until all ads have been displayed.
		*/
		QStringList			SF_01;
		QStringList			SF_02;
		QStringList			SF_03;
		QStringList			SF_04;
		QStringList			SF_05;
		QStringList			SF_06;
		QStringList			SF_07;
};

#endif

