/***************************************************************************
                          napsterdownload.h  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NAPSTERDOWNLOAD_H
#define NAPSTERDOWNLOAD_H


/**
  *@author John Donoghue
  */
#include "songinfo.h"

#include "napstertransfer.h"

//class NapsterConnection;
class Knapster2;
class KNAP_TransferPanel;
class KSocket;

class NapsterDownload1 : public NapsterTransfer
{
//  friend NapsterConnection;
//  friend Knapster2;
  friend class KNAP_TransferPanel;
//  char _buffer[2048];

  int _sock;
  int _file;

  KSocket *sock;
  
  int _listener;

  int _header_pos;
  bool _gotheader;

private:
  // download type 1
  NapsterDownload1(unsigned long ip,int port,const char *filename,const char *user,
        int speed,const char *dest);
  // download type 2
  NapsterDownload1(KSocket *s,const char *filename,const char *user,
        long size,int speed,const char *dest);
  
  bool header();
  bool data();
  bool init();

  // download type 2
  bool header2();
  bool init2();

  bool processDownload();

  bool setDownloadName(const char *path,bool trucate=false);

  inline int getSocket() { return _sock; }

  virtual void run_method();   // provide our own run method

  bool waitData(); // returns false if a timeout occured
public:
  virtual ~NapsterDownload1();

  bool start(int listen=-1,long sz=0);
};


#endif
