#include <klocale.h>
/****************************************************************************
** Form implementation generated from reading ui file './ipaddress.ui'
**
** Created: Sun Jun 3 13:49:31 2001
**      by:  The User Interface Compiler (uic)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/
#include "knap_ipaddressdlg.h"
#include <kconfig.h>
#include <kglobal.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <qvalidator.h>
#include <iostream>
 
#include <stdio.h>
 
#include <qmessagebox.h>

class TriadValidator : public QValidator
{
   public:
      TriadValidator(QWidget *parent)
	 : QValidator(parent)
	 {
	 }
      virtual ~TriadValidator() { }

      virtual State validate(QString &input,int &pos) const
      {
	 // nothing yet
	 if(input.length()==0) return
	    Intermediate;

	 // entering invalid symbol
	 if((input[pos-1]<'0' || input[pos-1]>'9') && input[pos-1]!='.')
	    return Invalid;

	 if(input.contains(".")==3 && input.findRev(".")!=input.length()-1)
	    return Acceptable;

	 return
	    Intermediate;
      }
}; 
class PositiveValidator : public QValidator
{
   public:
      PositiveValidator(QWidget *parent)
	 : QValidator(parent)
	 {
	 }
      virtual ~PositiveValidator() { }

      virtual State validate(QString &input,int &pos) const
      {
	 // nothing yet
	 if(input.length()==0) return
	    Intermediate;

	 // entering invalid symbol
	 if(input[pos-1]<'0' || input[pos-1]>'9')
	    return Invalid;

	 if(pos==1 && input[pos-1]=='0')
	    return Invalid;

	 return
	    Acceptable;
      }
}; 


/* 
 *  Constructs a KNAP_IPAddressDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
   KNAP_IPAddressDlg::KNAP_IPAddressDlg( QWidget* parent,  const char* name)
: QDialog( parent, name, true )
{
   ipaddress ="";
   
   if ( !name )
      setName( "KNAP_IPAddressDlg" );
   resize( 296, 140 ); 
   setCaption( i18n( "Connect To"  ) );
   setSizeGripEnabled( FALSE );
   KNAP_IPAddressDlgLayout = new QGridLayout( this ); 
   KNAP_IPAddressDlgLayout->setSpacing( 6 );
   KNAP_IPAddressDlgLayout->setMargin( 11 );

   ipaddress_text = new QLabel( this, "ipaddress_text" );
   ipaddress_text->setText( i18n( "IP Address"  ) );
   ipaddress_text->setAlignment( int( QLabel::AlignCenter ) );

   KNAP_IPAddressDlgLayout->addWidget( ipaddress_text, 0, 0 );

   address_edit = new QLineEdit( this, "address_edit" );
   address_edit->setMaxLength( 15 );
   address_edit->setEdited( FALSE );

   KConfig *config = KGlobal::config();
   QString tmp_address= config->readEntry("connectto_ipaddress","");
   
   if(isValidIPAddress(tmp_address))
	 address_edit->setText(tmp_address);

   KNAP_IPAddressDlgLayout->addMultiCellWidget( address_edit, 0, 0, 1, 2 );

   port_text = new QLabel( this, "port_text" );
   port_text->setText( i18n( "Port"  ) );

   KNAP_IPAddressDlgLayout->addWidget( port_text, 1, 0 );

   port_edit = new QLineEdit( this, "port_edit" );

   int tmp_port = config->readNumEntry("connectto_port",0);
   if(tmp_port>0) port_edit->setText(QString().setNum(tmp_port));

   KNAP_IPAddressDlgLayout->addWidget( port_edit, 1, 1 );
   QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
   KNAP_IPAddressDlgLayout->addItem( spacer, 1, 2 );
   QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
   KNAP_IPAddressDlgLayout->addItem( spacer_2, 2, 1 );

   Layout1 = new QHBoxLayout; 
   Layout1->setSpacing( 6 );
   Layout1->setMargin( 0 );
   QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
   Layout1->addItem( spacer_3 );

   buttonOk = new QPushButton( this, "buttonOk" );
   buttonOk->setText( i18n( "&OK"  ) );
   buttonOk->setAutoDefault( TRUE );
   buttonOk->setDefault( TRUE );
   Layout1->addWidget( buttonOk );

   buttonCancel = new QPushButton( this, "buttonCancel" );
   buttonCancel->setText( i18n( "&Cancel"  ) );
   buttonCancel->setAutoDefault( TRUE );
   Layout1->addWidget( buttonCancel );

   KNAP_IPAddressDlgLayout->addMultiCellLayout( Layout1, 4, 4, 0, 2 );

   Line1 = new QFrame( this, "Line1" );
   Line1->setFrameStyle( QFrame::HLine | QFrame::Sunken );

   KNAP_IPAddressDlgLayout->addMultiCellWidget( Line1, 3, 3, 0, 2 );

   // signals and slots connections
   connect( buttonOk, SIGNAL( clicked() ), this, SLOT( okPressed() ) );
   connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );

   // tab order
   setTabOrder( address_edit, port_edit );
   setTabOrder( port_edit, buttonOk );
   setTabOrder( buttonOk, buttonCancel );

   QValidator *val = new TriadValidator(address_edit);
   address_edit->setValidator(val);
   val = new PositiveValidator(port_edit);
   port_edit->setValidator(val);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KNAP_IPAddressDlg::~KNAP_IPAddressDlg()
{
   // no need to delete child widgets, Qt does it all for us
}

void KNAP_IPAddressDlg::okPressed()
{
   bool valid = true;

   QString address = address_edit->text();

   valid = isValidIPAddress(address);
  
   QString port = port_edit->text() ;
   if(port.length()==0) valid=false;

   ipport = port.toInt();
   if(ipport<=0) valid=false;

   if(valid == false)
      QMessageBox::warning(this,"Error","Invalid IP Address or port entered");
   else
   {
      ipaddress = address;

      KConfig *config = KGlobal::config();
      config->writeEntry("connectto_ipaddress",ipaddress);
      config->writeEntry("connectto_port",ipport);
      accept();
   }
} 

QString KNAP_IPAddressDlg::getIPAddress()
{
  if(ipaddress.length()==0) return "";
  else
     return ipaddress + ":" + QString().setNum(ipport);
}

bool KNAP_IPAddressDlg::isValidIPAddress(const QString &ip)
{
   bool valid = true;
   
   if(ip.length()>0)
   {
      if(ip.contains(".")>3) valid=false;
      else
      {
	 int a,b,c,d;

	 int i = sscanf(ip,"%d.%d.%d.%d",&a,&b,&c,&d);

	 //cerr << "i = " << i << "str: " << ipaddress << endl;

	 if(i!=4) valid == false;
	 if(a<0 || a>999)
	    valid = false;
	 if(b<0 || b>999)
	    valid = false;
	 if(c<0 || c>999)
	    valid = false;
	 if(d<0 || d>999)
	    valid = false;
       }
   }
   else
      valid = false;
 
   return valid;
}
