/***************************************************************************
                       kmfwizard.cpp  -  description
                          -------------------
 begin                : Wed Mar 20 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfwizard.h"

// qt includes
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qwizard.h>
#include <qlistbox.h>
#include <qinputdialog.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qmultilineedit.h>
#include <qtextview.h>
#include <qfile.h>
#include <qregexp.h>

// kde incluides
#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kurl.h>
#include <ktempfile.h>
#include <klineedit.h>
#include <kmessagebox.h>

// my includes
#include "core/kmfdoc.h"
#include "kmyfirewall.h" 
//#include "kmfview.h"
#include "core/iptrule.h"
#include "core/iptchain.h"
#include "core/kmferror.h"
#include "core/kmferrorhandler.h"
#include "core/kmfcheckinput.h"


KMFWizard::KMFWizard( QWidget *parent, const char *name ) : KMyFirewallWizard( parent, name ) {
	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler( "KMFWizard" );
	m_check_input = new KMFCheckInput();
	adjustSize();
}
KMFWizard::~KMFWizard() {}
void KMFWizard::slotInitDocument() {
	kdDebug() << "slotInitDocument()" << endl;
	kmfdoc = new KMFDoc( 0, "kmfdoc" );
}

void KMFWizard::slotHelp() {
	kdDebug() << "KMFWizard::slotHelp()" << endl;
	kapp->invokeHelp();
}

void KMFWizard::setupRuleset() {
	kdDebug() << "void KMFWizard::setupRuleset() " << endl;
	kdDebug() << "!!! CURRENTLY COMENTED" << endl;
	QString opt;
	QString* option_value = new QString();
	QPtrList<QString>* options = new QPtrList<QString>;
	QString name = "";
	QString chain = "";
	QString target = "";
	QString table = "";

	bool log = c_log->isChecked();
	bool limit_log = c_limit_log->isChecked();
	bool use_log_prefix = c_log_prefix->isChecked();
	QString log_prefix = t_log_prefix->text();

	if ( log ) {
		QString limit = "";
		QString burst = "";
		QString prefix = "";
		if ( limit_log ) {
			limit = "1/second";
			burst = "5";
		}
		if ( use_log_prefix ) {
			if ( !log_prefix.isEmpty() ) {
				prefix = log_prefix;
			}
		}
		for ( uint i = 0;i < kmfdoc->chains( "filter" ).count();i++ ) {
			IPTChain& tmp_chain = *kmfdoc->chains( "filter" ).at( i );
			QString tmp_name = tmp_chain.name();
			if ( tmp_name == "INPUT" ) {
				tmp_chain.setDropLogging( true, limit, burst, prefix );
			}
		}
	}

	// hosts tab
	//    bool log_in_trusted = c_trusted_log_in->isChecked();
	//    bool log_out_trusted = c_trusted_log_out->isChecked();
	//    bool log_in_evil = c_evil_log_in->isChecked();
	//    bool log_out_evil = c_evil_log_out->isChecked();
	//    bool log_servers = c_servers_log->isChecked();
	//    bool log_clients = c_clients_log->isChecked();

	for ( uint i = 0;i < lb_trusted->count();i++ ) {
		QString val = lb_trusted->text( i );
		QString num = num.setNum( i + 1 );
		name = "TRUSTED_" + num + "_SRC";
		chain = "INPUT";
		target = "ACCEPT";
		table = "filter";
		IPTRule* trusted_src_in = kmfdoc->addRule( name, chain, table, target );
		if ( c_trusted_log_in->isChecked() )
			trusted_src_in->setLogging( true );
		opt = "src_ip";
		options = new QPtrList<QString>;
		option_value = new QString( val );
		options->append( option_value );
		trusted_src_in->addRuleOption( opt, *options );

		name = "TRUSTED_" + num + "_DEST";
		chain = "OUTPUT";
		target = "ACCEPT";
		table = "filter";
		IPTRule* trusted_dest_out = kmfdoc->addRule( name, chain, table, target );
		if ( c_trusted_log_out->isChecked() )
			trusted_dest_out->setLogging( true );
		opt = "dest_ip";
		options = new QPtrList<QString>;
		option_value = new QString( val );
		options->append( option_value );
		trusted_dest_out->addRuleOption( opt, *options );
	}
	for ( uint i = 0;i < lb_evil->count();i++ ) {
		QString val = lb_evil->text( i );
		QString num = num.setNum( i + 1 );
		name = "EVIL_" + num + "_SRC";
		chain = "INPUT";
		target = "DROP";
		table = "filter";
		IPTRule* evil_src = kmfdoc->addRule( name, chain, table, target );
		if ( c_evil_log_in->isChecked() )
			evil_src->setLogging( true );
		opt = "src_ip";
		options = new QPtrList<QString>;
		option_value = new QString( val );
		options->append( option_value );
		evil_src->addRuleOption( opt, *options );

		name = "EVIL_" + num + "_DEST";
		chain = "OUTPUT";
		target = "DROP";
		table = "filter";
		IPTRule* evil_dest = kmfdoc->addRule( name, chain, table, target );
		if ( c_evil_log_out->isChecked() )
			evil_dest->setLogging( true );
		opt = "dest_ip";
		options = new QPtrList<QString>;
		option_value = new QString( val );
		options->append( option_value );
		evil_dest->addRuleOption( opt, *options );
	}
	for ( uint i = 0;i < lb_clients->count();i++ ) {
		QString val = lb_clients->text( i );
		QString num = num.setNum( i + 1 );
		name = "BAD_CLIENT_" + num;
		chain = "INPUT";
		target = "DROP";
		table = "filter";
		IPTRule* bad_client = kmfdoc->addRule( name, chain, table, target );
		if ( c_clients_log->isChecked() )
			bad_client->setLogging( true );
		opt = "src_ip";
		options = new QPtrList<QString>;
		option_value = new QString( val );
		options->append( option_value );
		bad_client->addRuleOption( opt, *options );
	}

	for ( uint i = 0;i < lb_servers->count();i++ ) {
		QString val = lb_servers->text( i );
		QString num = num.setNum( i + 1 );
		name = "BAD_SERVER_" + num;
		chain = "OUTPUT";
		target = "DROP";
		table = "filter";
		IPTRule* bad_servers = kmfdoc->addRule( name, chain, table, target );
		if ( c_servers_log->isChecked() )
			bad_servers->setLogging( true );
		opt = "dest_ip";
		options = new QPtrList<QString>;
		option_value = new QString( val );
		options->append( option_value );
		bad_servers->addRuleOption( opt, *options );
	}

	// outgoing rules
	bool restrict_outgoing = c_restrict_outgoing->isChecked();
	bool out_dns = c_out_dns->isChecked();
	bool out_www = c_out_www->isChecked();
	bool out_ftp = c_out_ftp->isChecked();
	//    bool out_irc = c_out_irc->isChecked();
	bool out_telnet = c_out_telnet->isChecked();
	bool out_ssh = c_out_ssh->isChecked();
	bool out_nfs = c_out_nfs->isChecked();
	bool out_smb = c_out_smb->isChecked();
	bool out_ldap = c_out_ldap->isChecked();

	bool out_smtp = c_out_smtp->isChecked();
	bool out_pop = c_out_pop->isChecked();
	bool out_pop_sec = c_out_pop_sec->isChecked();
	bool out_imap = c_out_imap->isChecked();
	bool out_sec_imap = c_out_sec_imap->isChecked();
	QString tmp_name = "OUTPUT";
	IPTChain* ch = kmfdoc->table( "filter" ) ->chainForName( tmp_name );
	if ( ch == 0 )
		return ;
	QString tg = "DROP";
	ch->setDefaultTarget( tg );

	if ( restrict_outgoing ) {
		name = "PING_OUTPUT";
		chain = "OUTPUT";
		target = "ACCEPT";
		table = "filter";
		// ping icmp
		IPTRule* ping_out_rule = kmfdoc->addRule( name, chain, table, target );
		opt = "icmp";
		options = new QPtrList<QString>;
		option_value = new QString( "" );
		options->append( option_value );
		ping_out_rule->addRuleOption( opt, *options );

		name = "LOOPBACK_OUTPUT";
		chain = "OUTPUT";
		target = "ACCEPT";
		table = "filter";

		IPTRule* lo_out_rule = kmfdoc->addRule( name, chain, table, target );
		opt = "out_int";
		options = new QPtrList<QString>;
		option_value = new QString( "lo" );
		options->append( option_value );
		lo_out_rule->addRuleOption( opt, *options );

		opt = "src_ip";
		options = new QPtrList<QString>;
		option_value = new QString( "127.0.0.1" );
		options->append( option_value );
		lo_out_rule->addRuleOption( opt, *options );
		if ( out_ldap ) {
			name = "LDAP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* ldap_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "udp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "389" );
			options->append( option_value );
			ldap_rule->addRuleOption( opt, *options );

			name = "SEC_LDAP_UDP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* sec_udp_ldap_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "udp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "636" );
			options->append( option_value );
			sec_udp_ldap_rule->addRuleOption( opt, *options );

			name = "SEC_LDAP_TCP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* sec_tcp_ldap_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "636" );
			options->append( option_value );
			sec_tcp_ldap_rule->addRuleOption( opt, *options );
		}
		if ( out_dns ) {
			name = "DNS_UDP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* dns_udp_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "udp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "53" );
			options->append( option_value );
			dns_udp_rule->addRuleOption( opt, *options );

			name = "DNS_TCP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* dns_tcp_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "53" );
			options->append( option_value );
			dns_tcp_rule->addRuleOption( opt, *options );
		}
		if ( out_www ) {
			name = "WWW";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* www_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "80" );
			options->append( option_value );
			www_rule->addRuleOption( opt, *options );


			name = "WWW-PROXY";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* www_proxy_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "8080" );
			options->append( option_value );
			www_proxy_rule->addRuleOption( opt, *options );

			name = "SEC_WWW";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* www_sec_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "443" );
			options->append( option_value );
			www_sec_rule->addRuleOption( opt, *options );
		}
		if ( out_smtp ) {
			name = "SMTP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* smtp_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "25" );
			options->append( option_value );
			smtp_rule->addRuleOption( opt, *options );
		}
		if ( out_pop ) {
			name = "POP3";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* pop_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "110" );
			options->append( option_value );
			pop_rule->addRuleOption( opt, *options );
		}
		if ( out_pop_sec ) {
			name = "SEC_POP3";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* sec_pop_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "995" );
			options->append( option_value );
			sec_pop_rule->addRuleOption( opt, *options );
		}
		if ( out_imap ) {
			name = "IMAP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* imap_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "143" );
			options->append( option_value );
			imap_rule->addRuleOption( opt, *options );
		}
		if ( out_sec_imap ) {
			name = "SEC_IMAP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* sec_imap_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "585" );
			options->append( option_value );
			sec_imap_rule->addRuleOption( opt, *options );
		}
		if ( out_ftp ) {
			name = "FTP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* ftp_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "21" );
			options->append( option_value );
			ftp_rule->addRuleOption( opt, *options );
		}
		if ( out_telnet ) {
			// TELNET
			name = "TELNET";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* telnet_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "23" );
			options->append( option_value );
			telnet_rule->addRuleOption( opt, *options );

			//					 kmfdoc->addChainRule(*telnet_rule);
		}
		if ( out_ssh ) {
			// SSH
			name = "SSH";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* ssh_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "22" );
			options->append( option_value );
			ssh_rule->addRuleOption( opt, *options );
		}
		if ( out_smb ) {
			// SMB
			name = "SMB_NS";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* smb_ns_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "137" );
			options->append( option_value );
			smb_ns_rule->addRuleOption( opt, *options );

			name = "SMB_DGM";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* smb_dgm_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "138" );
			options->append( option_value );
			smb_dgm_rule->addRuleOption( opt, *options );

			name = "SMB_SSN";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* smb_ssn_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "139" );
			options->append( option_value );
			smb_ssn_rule->addRuleOption( opt, *options );
		}
		if ( out_nfs ) {
			// NFS
			name = "NFS_TCP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* nfs_tcp_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "2049" );
			options->append( option_value );
			nfs_tcp_rule->addRuleOption( opt, *options );

			name = "NFS_UDP";
			chain = "OUTPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* nfs_udp_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "udp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "2049" );
			options->append( option_value );
			nfs_udp_rule->addRuleOption( opt, *options );
		}

		for ( uint i = 0; i < custom_out_services.count();i++ ) {
			QString* option_value = new QString();
			QPtrList<QString>* options = new QPtrList<QString>;

			QString port_prot_str = *custom_out_services.at( i );
			QString name = *custom_out_services_name.at( i );
			if ( name.length() > 19 ) {
				QString proto = name.right( 4 );
				name = name.left( 14 );
				name += proto;
			}
			int l = port_prot_str.find( "|" );
			QString port = port_prot_str.left( l );
			QString prot = port_prot_str.right( ( port_prot_str.length() - 1 ) - l );
			kdDebug() << "Found Rule: " << name << " for port: " << port << " and protocol: " << prot << endl;

			QString chain = "OUTPUT";
			QString target = "ACCEPT";
			QString table = "filter";
			IPTRule* custom_rule = kmfdoc->addRule( name, chain, table, target );
			if ( prot == "TCP" ) {
				opt = "tcp";
			} else if ( prot == "UDP" ) {
				opt = "udp";
			}
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( port );
			options->append( option_value );
			custom_rule->addRuleOption( opt, *options );
		}


		name = "CONNRACK_OUTPUT";
		chain = "OUTPUT";
		target = "ACCEPT";
		table = "filter";

		IPTRule* con_out_rule = kmfdoc->addRule( name, chain, table, target );
		opt = "state";
		options = new QPtrList<QString>;
		option_value = new QString( "RELATED,ESTABLISHED" );
		options->append( option_value );
		con_out_rule->addRuleOption( opt, *options );

	} else {
		QString tmp_name = "OUTPUT";
		IPTChain* ch = kmfdoc->table( "filter" ) ->chainForName( tmp_name );
		if ( ch == 0 )
			return ;
		QString tg = "ACCEPT";
		ch->setDefaultTarget( tg );
	}

	// incoming tab
	bool allow_incoming = c_allow_incoming->isChecked();
	bool in_dns = c_in_dns->isChecked();
	bool in_www = c_in_www->isChecked();
	bool in_ftp = c_in_ftp->isChecked();
	bool in_pop = c_in_pop3->isChecked();
	bool in_telnet = c_in_telnet->isChecked();
	bool in_ssh = c_in_ssh->isChecked();
	bool in_nfs = c_in_nfs->isChecked();
	bool in_smb = c_in_smb->isChecked();
	bool in_smtp = c_in_smtp->isChecked();
	bool in_imap = c_in_imap->isChecked();
	bool in_sec_imap = c_in_sec_imap->isChecked();
	tmp_name = "INPUT";
	ch = kmfdoc->table( "filter" ) ->chainForName( tmp_name );
	if ( ch == 0 )
		return ;
	tg = "DROP";
	ch->setDefaultTarget( tg );

	tmp_name = "FORWARD";
	ch = kmfdoc->table( "filter" ) ->chainForName( tmp_name );
	if ( ch == 0 )
		return ;
	tg = "DROP";
	ch->setDefaultTarget( tg );

	if ( allow_incoming ) {
		if ( in_dns ) {
			name = "DNS_TCP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* dns_tcp_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "53" );
			options->append( option_value );
			dns_tcp_server_rule->addRuleOption( opt, *options );

			name = "DNS_UDP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* dns_udp_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "udp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "53" );
			options->append( option_value );
			dns_udp_server_rule->addRuleOption( opt, *options );
		}
		if ( in_www ) {
			// www
			name = "WWW_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* www_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "80" );
			options->append( option_value );
			www_server_rule->addRuleOption( opt, *options );


			name = "WWW-PROXY_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* www_proxy_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "8080" );
			options->append( option_value );
			www_proxy_server_rule->addRuleOption( opt, *options );

			name = "SEC_WWW_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* www_sec_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "443" );
			options->append( option_value );
			www_sec_server_rule->addRuleOption( opt, *options );
		}
		if ( in_pop ) {
			name = "POP3_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* pop_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "110" );
			options->append( option_value );
			pop_rule->addRuleOption( opt, *options );
		}
		if ( in_smtp ) {
			// email
			name = "SMTP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* smtp_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "25" );
			options->append( option_value );
			smtp_server_rule->addRuleOption( opt, *options );
		}
		if ( in_imap ) {
			name = "IMAP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* imap_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "143" );
			options->append( option_value );
			imap_server_rule->addRuleOption( opt, *options );

		}
		if ( in_sec_imap ) {

			name = "SEC_IMAP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* sec_imap_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "585" );
			options->append( option_value );
			sec_imap_server_rule->addRuleOption( opt, *options );
		}
		if ( in_ftp ) {
			// FTP
			name = "FTP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* ftp_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "21" );
			options->append( option_value );
			ftp_server_rule->addRuleOption( opt, *options );
		}
		if ( in_telnet ) {
			// TELNET
			name = "TELNET_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* telnet_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "23" );
			options->append( option_value );
			telnet_server_rule->addRuleOption( opt, *options );
		}
		if ( in_ssh ) {
			// SSH
			name = "SSH_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";

			IPTRule* ssh_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "22" );
			options->append( option_value );
			ssh_server_rule->addRuleOption( opt, *options );
		}
		if ( in_smb ) {
			// SMB
			name = "SMB_NS_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* smb_ns_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "137" );
			options->append( option_value );
			smb_ns_server_rule->addRuleOption( opt, *options );

			name = "SMB_DGM_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* smb_dgm_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "138" );
			options->append( option_value );
			smb_dgm_server_rule->addRuleOption( opt, *options );

			name = "SMB_SSN_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* smb_ssn_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "139" );
			options->append( option_value );
			smb_ssn_server_rule->addRuleOption( opt, *options );
		}
		if ( in_nfs ) {
			// NFS
			name = "NFS_TCP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* nfs_tcp_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "tcp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "2049" );
			options->append( option_value );
			nfs_tcp_server_rule->addRuleOption( opt, *options );

			name = "NFS_UDP_SERVER";
			chain = "INPUT";
			target = "ACCEPT";
			table = "filter";
			IPTRule* nfs_udp_server_rule = kmfdoc->addRule( name, chain, table, target );
			opt = "udp";
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( "2049" );
			options->append( option_value );
			nfs_udp_server_rule->addRuleOption( opt, *options );
		}

		for ( uint i = 0; i < custom_in_services.count();i++ ) {
			QString* option_value = new QString();
			QPtrList<QString>* options = new QPtrList<QString>;

			QString port_prot_str = *custom_in_services.at( i );
			int l = port_prot_str.find( "|" );
			QString port = port_prot_str.left( l );
			QString prot = port_prot_str.right( ( port_prot_str.length() - 1 ) - l );
			QString name = *custom_in_services_name.at( i );
			if ( name.length() > 19 ) {
				QString proto = name.right( 4 );
				name = name.left( 14 );
				name += proto;
			}
			kdDebug() << "Found Rule: " << name << " for port: " << port << " and protocol: " << prot << endl;

			QString chain = "INPUT";
			QString target = "ACCEPT";
			QString table = "filter";
			IPTRule* custom_rule = kmfdoc->addRule( name, chain, table, target );
			if ( prot == "TCP" ) {
				opt = "tcp";
			} else if ( prot == "UDP" ) {
				opt = "udp";
			}
			options = new QPtrList<QString>;
			option_value = new QString( "" );
			options->append( option_value );
			option_value = new QString( port );
			options->append( option_value );
			custom_rule->addRuleOption( opt, *options );
		}
	}
	bool ping = c_ping->isChecked();
	if ( ping ) {
		name = "PING_INPUT";
		chain = "INPUT";
		target = "ACCEPT";
		table = "filter";
		// ping icmp
		IPTRule* ping_rule = kmfdoc->addRule( name, chain, table, target );
		if ( c_limit_ping->isChecked() ) {
			opt = "limit";
			options = new QPtrList<QString>;
			option_value = new QString( "5/minute" );
			options->append( option_value );
			ping_rule->addRuleOption( opt, *options );
		}
		opt = "icmp";
		options = new QPtrList<QString>;
		option_value = new QString( "echo-request" );
		options->append( option_value );
		ping_rule->addRuleOption( opt, *options );
	}

	// conntrack
	name = "CONNRACK_INPUT";
	chain = "INPUT";
	target = "ACCEPT";
	table = "filter";

	IPTRule* con_in_rule = kmfdoc->addRule( name, chain, table, target );
	opt = "state";
	options = new QPtrList<QString>;
	option_value = new QString( "RELATED,ESTABLISHED" );
	options->append( option_value );
	con_in_rule->addRuleOption( opt, *options );

	// loopback input
	name = "LOOPBACK_INPUT";
	chain = "INPUT";
	target = "ACCEPT";
	table = "filter";

	IPTRule* lo_in_rule = kmfdoc->addRule( name, chain, table, target );
	opt = "in_int";
	options = new QPtrList<QString>;
	option_value = new QString( "lo" );
	options->append( option_value );
	lo_in_rule->addRuleOption( opt, *options );

	opt = "dest_ip";
	options = new QPtrList<QString>;
	option_value = new QString( "127.0.0.1" );
	options->append( option_value );
	lo_in_rule->addRuleOption( opt, *options );

	if ( c_use_rpfilter->isChecked() ) {
		kmfdoc->setUseRPFilter( true );
		if ( c_log_martians->isChecked() )
			kmfdoc->setUseMartians( true );
		else
			kmfdoc->setUseMartians( false );
	} else {
		kmfdoc->setUseRPFilter( false );
		kmfdoc->setUseMartians( false );
	}
	if ( c_use_modules->isChecked() )
		kmfdoc->setUseModules( true );
	else
		kmfdoc->setUseModules( false );

	kmfdoc->setUseIPFwd( false ); // disable IP frowarding
	kmfdoc->setUseNat( false );  // disable nat table
	kmfdoc->setUseMangle( false ); // disable mangle table
	// let the main app load the document
	//    emit newDocument(kmfdoc);

}

void KMFWizard::reject() {
	QWizard::reject();
}


void KMFWizard::slotAddTrusted() {
	kdDebug() << "KMyFirewallWizard::slotAddTrusted()" << endl;
	bool ok = FALSE;
	const QString greeting = i18n( "New Trusted Host" );
	const QString label = i18n( "Please enter the name or IP address of the host you would like to add." );
	QString text = QInputDialog::getText( greeting, label, QLineEdit::Normal, QString::null, &ok, this, "dsa" );
	if ( ok && !text.isEmpty() ) {
		kdDebug() << "Adding Trusted Host: " << text << endl;
		lb_trusted->insertItem( text );
	} else {
		return ;
	}
}

void KMFWizard::slotDelTrusted() {
	kdDebug() <<  "KMFWizard::slotDelClient()" << endl;
	int index = lb_trusted->currentItem();
	kdDebug() << "index " << index << endl;
	if ( index < 0 ) {
		KMessageBox::sorry( this, i18n( "<p>Please select a service in the list to delete it." ), i18n( "Wizard" ) );
		return ;
	} else {
		switch ( QMessageBox::information( this, i18n( "Wizard" ),
		                                   i18n( "Are you sure that you want to delete\n"
		                                         "this host?\n"
		                                         "Please note there is no way to get it back." ),
		                                   i18n( "&OK" ), i18n( "&Cancel" ),
		                                   0, 2 ) ) {

			case 0:    // OK clicked
				lb_trusted->removeItem( index );
				break;
		}
	}
}

void KMFWizard::slotAddEvil() {
	kdDebug() << "KMyFirewallWizard::slotAddEvil()"  << endl;
	bool ok = FALSE;
	const QString greeting = i18n( "New Malicious Host" );
	const QString label = i18n( "Please enter the name or IP address of the host you would like to add." );
	QString text = QInputDialog::getText( greeting, label, QLineEdit::Normal, QString::null, &ok, this, "dsa" );
	if ( ok && !text.isEmpty() ) {
		kdDebug() << "Adding Evil Host: " << text << endl;
		lb_evil->insertItem( text );
	} else {
		return ;
	}
}

void KMFWizard::slotDelEvil() {
	kdDebug() <<  "KMFWizard::slotDelClient()"  << endl;
	int index = lb_evil->currentItem();
	kdDebug() << "index " << index << endl;
	if ( index < 0 ) {
		KMessageBox::sorry( this, i18n( "<p>Please select a service in the list to delete it." ), i18n( "Wizard" ) );
		return ;
	} else {
		switch ( QMessageBox::information( this, i18n( "Wizard" ),
		                                   i18n( "Are you sure that you want to delete\n"
		                                         "this host?\n"
		                                         "Please note there is no way to get it back." ),
		                                   i18n( "&OK" ), i18n( "&Cancel" ),
		                                   0, 2 ) ) {

			case 0:    // OK clicked
				lb_evil->removeItem( index );
				break;
		}
	}
}

void KMFWizard::slotAddServer() {
	kdDebug() << "KMyFirewallWizard::slotAddServer()"<< endl;
	bool ok = FALSE;
	const QString greeting = i18n( "New Forbidden Server" );
	const QString label = i18n( "Please enter the name or IP address of the host you would like to add." );
	QString text = QInputDialog::getText( greeting, label, QLineEdit::Normal, QString::null, &ok, this, "dsa" );
	if ( ok && !text.isEmpty() ) {
		kdDebug() << "Adding Forbidden Server Host: " << text << endl;
		lb_servers->insertItem( text );
	} else {
		return ;
	}
}

void KMFWizard::slotDelServer() {
	kdDebug() << "KMFWizard::slotDelClient()" << endl;
	int index = lb_servers->currentItem();
	kdDebug() << "index " << index << endl;
	if ( index < 0 ) {
		KMessageBox::sorry( this, i18n( "<p>Please select a service in the list to delete it." ), i18n( "Wizard" ) );
		return ;
	} else {
		switch ( QMessageBox::information( this, i18n( "Wizard" ),
		                                   i18n( "Are you sure that you want to delete\n"
		                                         "this host?\n"
		                                         "Please note there is no way to get it back." ),
		                                   i18n( "&OK" ), i18n( "&Cancel" ),
		                                   0, 2 ) ) {

			case 0:    // OK clicked
				lb_servers->removeItem( index );
				break;
		}
	}
}

void KMFWizard::slotAddClient() {
	kdDebug() << "KMyFirewallWizard::slotAddClient()"<< endl;
	bool ok = FALSE;
	const QString greeting = i18n( "New Forbidden Client" );
	const QString label = i18n( "Please enter the name or IP address of the host you would like to add." );
	QString text = QInputDialog::getText( greeting, label, QLineEdit::Normal, QString::null, &ok, this, "dsa" );
	if ( ok && !text.isEmpty() ) {
		kdDebug() << "Adding Forbidden Client Host: " << text << endl;
		lb_clients->insertItem( text );
	} else {
		return ;
	}
}

void KMFWizard::slotDelClient() {
	kdDebug() << "KMFWizard::slotDelClient()"<< endl;
	int index = lb_clients->currentItem();
	kdDebug() << "index " << index << endl;
	if ( index < 0 ) {
		KMessageBox::sorry( this, i18n( "<p>Please select a service in the list to delete it." ), i18n( "Wizard" ) );
		return ;
	} else {
		switch ( QMessageBox::information( this, i18n( "Wizard" ),
		                                   i18n( "Are you sure that you want to delete\n"
		                                         "this host?\n"
		                                         "Please note there is no way to get it back." ),
		                                   i18n( "&OK" ), i18n( "&Cancel" ),
		                                   0, 2 ) ) {

			case 0:    // OK clicked
				lb_clients->removeItem( index );
				break;
		}
	}
}
void KMFWizard::slotDelOutService() {
	kdDebug() << "KMFWizard::slotDelOutService()"<< endl;
	int index = lb_out_services->currentItem();
	kdDebug() << "index " << index << endl;
	if ( index < 0 ) {
		KMessageBox::sorry( this, i18n( "<p>Please select a service in the list to delete it." ), i18n( "Wizard" ) );
		return ;
	} else {
		switch ( QMessageBox::information( this, i18n( "Wizard" ),
		                                   i18n( "Are you sure that you want to delete\n"
		                                         "this service?\n"
		                                         "Please note there is no way to get it back." ),
		                                   i18n( "&OK" ), i18n( "&Cancel" ),
		                                   0, 2 ) ) {

			case 0:    // OK clicked
				lb_out_services->removeItem( index );
				custom_out_services.remove( index );
				custom_out_services_name.remove( index );
				break;
		}
	}
}

void KMFWizard::slotAddInService() {
	kdDebug() << "KMyFirewallWizard::slotAddInService()"<< endl;
	QString text = t_new_in_service->text();
	QString ru_na = t_new_in_service_name->text();
	int l = custom_in_services.count();
	l++;
	if ( c_new_in_service_tcp->isChecked() || c_new_in_service_udp->isChecked() ) {
		if ( !text.isEmpty() && !ru_na.isEmpty() ) {
			// Sanity checks
			if ( ru_na.length() > 9 ) {
				KMessageBox::error( 0, i18n( "<p>Names for custom rules must not be longer then 9 characters and "
				                             "they should only contain letters from <b>A-Z</b>, <b>a-z</b>, <b>0-9</b>, <b>_</b> and <b>-</b>." ) );
				return ;

			}
			bool valid = TRUE;
			QRegExp exp( "^[a-zA-Z0-9_-]{1,20}$", false );
			if ( !ru_na.contains( exp ) )
				valid = false;
			if ( !valid ) {
				KMessageBox::error( 0, i18n( "<p>Names for custom rules must not be longer then 9 characters and "
				                             "they should only contain letters from <b>A-Z</b>, <b>a-z</b>, <b>0-9</b>, <b>_</b> and <b>-</b>." ) );
				return ;
			}
			m_err = m_check_input->checkInput( text, "PORT/PORTRANGE" );
			if ( !m_err_handler->showError( m_err ) )
				return ;

			// End of sanity checks
			kdDebug() << "Adding new Incoming service: " << text << endl;
			if ( c_new_in_service_tcp->isChecked() ) {
				QString * name = new QString( "Custom_" + ru_na + "_TCP" );
				QString *val = new QString( text + "|TCP" );
				custom_in_services.append( val );
				custom_in_services_name.append( name );
				lb_in_services->insertItem( *name );
				l++;
			}
			if ( c_new_in_service_udp->isChecked() ) {
				QString * name = new QString( "Custom_" + ru_na + "_UDP" );
				QString *val = new QString( text + "|UDP" );
				custom_in_services.append( val );
				custom_in_services_name.append( name );
				lb_in_services->insertItem( *name );
				l++;
			}
			t_new_in_service->setEnabled( false );
			t_new_in_service_name->setEnabled( false );
		} else {
			KMessageBox::sorry( this, i18n( "You must define a name and a port number/range or service name." ), i18n( "Wizard" ) );
			return ;
		}
	} else {
		KMessageBox::sorry( this, i18n( "You must choose at least one protocol." ), i18n( "Wizard" ) );
		return ;
	}
}
void KMFWizard::slotAddOutService() {
	kdDebug() << "KMyFirewallWizard::slotAddOutService()"<< endl;
	QString text = t_new_out_service->text();
	QString ru_na = t_new_out_service_name->text();
	int l = custom_out_services.count();
	l++;
	if ( c_new_out_service_tcp->isChecked() || c_new_out_service_udp->isChecked() ) {
		// Sanity checks
		if ( ru_na.length() > 9 ) {
			KMessageBox::error( 0, i18n( "<p>Names for custom rules must not be longer then 9 characters and "
			                             "they should only contain letters from <b>A-Z</b>, <b>a-z</b>, <b>0-9</b>, <b>_</b> and <b>-</b>." ) );
			return ;

		}
		bool valid = TRUE;
		QRegExp exp( "^[a-zA-Z0-9_-]{1,20}$", false );
		if ( !ru_na.contains( exp ) )
			valid = false;
		if ( !valid ) {
			KMessageBox::error( 0, i18n( "<p>Names for custom rules must not be longer then 9 characters and "
			                             "they should only contain letters from <b>A-Z</b>, <b>a-z</b>, <b>0-9</b>, <b>_</b> and <b>-</b>." ) );
			return ;
		}
		m_err = m_check_input->checkInput( text, "PORT/PORTRANGE" );
		if ( !m_err_handler->showError( m_err ) )
			return ;
		// End of sanity checks

		if ( !text.isEmpty() && !ru_na.isEmpty() ) {
			kdDebug() << "Adding new outgoing service: " << text << endl;
			if ( c_new_out_service_tcp->isChecked() ) {
				QString * name = new QString( "Custom_" + ru_na + "_TCP" );
				QString *val = new QString( text + "|TCP" );
				custom_out_services.append( val );
				custom_out_services_name.append( name );
				lb_out_services->insertItem( *name );
				l++;
			}
			if ( c_new_out_service_udp->isChecked() ) {
				QString * name = new QString( "Custom_" + ru_na + "_UDP" );
				QString *val = new QString( text + "|UDP" );
				custom_out_services.append( val );
				custom_out_services_name.append( name );
				lb_out_services->insertItem( *name );
				l++;
			}
			t_new_out_service->setEnabled( false );
			t_new_out_service_name->setEnabled( false );

		} else {
			KMessageBox::sorry( this, i18n( "You must define a name and a number/range or service name." ), i18n( "Wizard" ) );
			return ;
		}
	} else {
		KMessageBox::sorry( this, i18n( "You must choose at least one protocol." ), i18n( "Wizard" ) );
		return ;
	}
}
void KMFWizard::slotDelInService() {
	kdDebug() << "KMFWizard::slotDelOutService()" << endl;
	int index = lb_in_services->currentItem();
	kdDebug() << "index " << index << endl;
	if ( index < 0 ) {
		KMessageBox::sorry( this, i18n( "Please select a service\nin the list to delete it." ), i18n( "Wizard" ) );
		return ;
	} else {
		switch ( QMessageBox::information( this, i18n( "Wizard" ),
		                                   i18n( "Are you sure that you want to delete\n"
		                                         "this service?\n"
		                                         "Please note there is no way to get it back." ),
		                                   i18n( "&OK" ), i18n( "&Cancel" ),
		                                   0, 2 ) ) {

			case 0:    // OK clicked
				custom_in_services.remove( index );
				custom_in_services_name.remove( index );
				lb_in_services->removeItem( index );
				break;
		}
	}
}
void KMFWizard::slotFinished( bool finished ) {
	setFinishEnabled( install, finished );
}
void KMFWizard::slotPreviewScript() {
	setupRuleset();
	KTempFile *tmp_file = new KTempFile();
	const QString file = tmp_file->name();

	kmfdoc->createFirewallScript( file );

	if ( !file.isEmpty() ) {
		QFile f( file );
		bool isopen = f.open( IO_ReadOnly );
		if ( isopen ) {
			QTextStream ts( &f );
			QString test;
			while ( !ts.eof() ) {
				QString s;
				s = ts.readLine();
				test.append( s );
				test.append( "\n" );
			}
			ml_preview->setText( test );
			f.close();
			f.remove();
		} else {
			KMessageBox::sorry( this, i18n( "Input file %1 could not be opened." ).arg( file ) , i18n( "Output Viewer" ) );
		}
	}
	kmfdoc->clear();
}

void KMFWizard::slotEnableNewOutService() {
	kdDebug() << "void KMFWizard::slotEnableNewOutService()" << endl;
	t_new_out_service->setEnabled( true );
	t_new_out_service_name->setEnabled( true );
}

void KMFWizard::slotEnableNewInService() {
	kdDebug() << "void KMFWizard::slotEnableNewInService()" << endl;
	t_new_in_service->setEnabled( true );
	t_new_in_service_name->setEnabled( true );
}

void KMFWizard::accept() {
	setupRuleset();
	KMyFirewall* mainApp = ( KMyFirewall* ) parent();
	kmfdoc->changed();
	mainApp->slotFileClose();
	mainApp->slotLoadDocument( kmfdoc );
	if ( c_install_fw->isChecked() ) {
		mainApp->slotInstallFirewall();
	}
	if ( c_start_fw->isChecked() ) {
		mainApp->runFirewall();
	}
	mainApp->toggleActions( true );
	mainApp->setCaption( i18n( "Unsaved New Firewall" ) );
	QWizard::accept();
}
#include "kmfwizard.moc"
