/***************************************************************************
                       kmfoc.h  -  description
                          -------------------
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFDOC_H
#define KMFDOC_H

//project includes
#include "iptchain.h"
#include "iptrule.h"
#include "iptable.h"


// qt includes
#include "qdict.h"
#include "qptrlist.h"
#include "qstring.h"
#include "qobject.h"

// kde includes
#include "kurl.h"

/**
  *@author Christian Hubinger
  */


class KMFErrorHandler;
class KMFError;
class KURL;

class KMFDoc : public QObject {
	Q_OBJECT

public:
	KMFDoc( QObject*, const char* );
	~KMFDoc();

	void saved();
	void changed();

	/** resets the document to the initial values
	*/
	void clear();

	/** Writes the shellscrip that contains the iptables commands to settup
		the firewall to file.
		If file = QString::null a SaveAs dialog will popup.
	*/
	KMFError* createFirewallScript( const QString& file = QString::null ); // writes all neccesary scripts

	/** Writes the initscript to file
			
	 */
	KMFError* createInitScript( const QString& file ); // writes all neccesary scripts

	/** Writes the xml-representation of this document to file.
			If file = QString::null a SaveAs dialog will popup.
	 */
	KMFError* exportXMLRuleset( const KURL& );

	KMFDoc* parseXMLRuleset( const KURL& );

	/** Writes the xml-representation of this document a String and returns it.
	 */
	const QString& getXMLRuleset();

	/** add a rule
	*/
	IPTRule* addRule( QString& name, QString& chain, QString& table, QString& chain_target );

	/** add a chain by generating a new IPTChain object
	*/
	KMFError* addChain( QString& chain_name, QString& chain_table, QString& chain_target, bool builtin );

	/** add a chain by generating a new IPTChain object
	*/
	KMFError* addChain( IPTChain& );

	/** delete the given chain from the ruleset
	*/
	KMFError* delChain( IPTChain* );

	/** deletes the rule from the ruleset
	*/
	bool delChainRule( IPTRule& );

	bool isEmpty();
	bool isSaved();

	// document get/set options
	void setUseFilter( bool on );
	void setUseNat( bool on );
	void setUseMangle( bool on );
	void setUseIPFwd( bool on );
	void setUseRPFilter( bool on );
	void setUseMartians( bool on );
	void setUseSynCookies( bool on );
	void setUseModules( bool on );

	bool useFilter() const {
		return use_filter;
	};
	bool useNat() const {
		return use_nat;
	};
	bool useMangle() const {
		return use_mangle;
	};
	bool useIPFwd() const {
		return use_ipfwd;
	};
	bool useRPFilter() const {
		return use_rp_filter;
	};
	bool useMartians() const {
		return use_martians;
	};
	bool useSynCookies() const {
		return use_syn_cookies;
	};
	bool useModules() const {
		return use_modules;
	};

  // return the documents KURL pointer
  const KURL& url() const {
		return m_url;
	};

	// set the Documents url
  void setUrl( const KURL& url);

	// set the Documents url
  void setFileName( const QString&);

	/** returns a pointer to the chain defined by name table
	*/
	IPTChain* chain( QString& name, QString& table );


	// returns the table with the given name
	IPTable* table( const QString& table );

	// returns all chains in the specified table (valid values are "filter" "nat" "mangle")
	QPtrList<IPTChain> chains( const QString& /*table*/ );

	//	void setFilterTable( IPTable* table );
	//	void setNatTable( IPTable* table );
	//	void setMangleTable( IPTable* table );



private:   	// data
	/** Initializes the document with all builtin chains and tables
		nonused builtin chains and tables will be deactivated when
		lodaning the ruleset.
	*/
	void initKMFDoc();

  // KURL of the document
  KURL m_url;
	
	// IPTable objects that store the Chains
	IPTable* m_ipt_filter;
	IPTable* m_ipt_nat;
	IPTable* m_ipt_mangle;

	// error handler
	KMFErrorHandler *m_err_handler;
	KMFError *m_err;

	// document options
	bool use_filter;
	bool use_nat;
	bool use_mangle;
	bool use_ipfwd;
	bool use_rp_filter;
	bool use_martians;
	bool use_syn_cookies;
	bool use_modules;

	// is saved
	bool is_saved;


signals:
	void documentChanged();
	void documentChanged( KMFDoc* );

};


#endif
