#include <kapplication.h>       // for 'kapp'
#include <kconfig.h>            // for KConfig
#include <klocale.h>            // for i18n()

#include "kmfconfiguration.h"

/*const QString KMFConfiguration::m_defaultText = i18n("Hello World");
const QFont   KMFConfiguration::m_defaultFont = QFont("Helvetica");
const QColor  KMFConfiguration::m_defaultTextColor = Qt::black;*/

const int KMFConfiguration::m_defaultMaxUndo = 10;
const bool KMFConfiguration::m_defaultShowSplash = true;
const bool KMFConfiguration::m_defaultGentooMode = false;
const bool KMFConfiguration::m_defaultShowDocumentation = true;
const bool KMFConfiguration::m_defaultShowCommandLine = false;
const QString KMFConfiguration::m_defaultInitPath = "/etc/init.d/";
const QString KMFConfiguration::m_defaultRcDefaultPath = "/etc/init.d/rc5.d/";
const QString KMFConfiguration::m_defaultIptPath = "/usr/sbin/iptables";
const QString KMFConfiguration::m_defaultModprobePath = "/usr/sbin/modprobe";
const QStringList KMFConfiguration::m_defaultInterfaces;

KMFConfiguration::KMFConfiguration() {
	m_firstRun = true;
	m_upAndRunning = false;
	m_hasOpenDoc = false;
	m_currentConfiguration = "";
	read(); // read the settings or set them to the default values
}

void KMFConfiguration::read() {
	KConfig * conf = kapp->config();
	conf->sync();
	conf->setGroup( "GENERAL" );
	m_firstRun = conf->readBoolEntry( "firstRun", m_firstRun );
	m_maxUndo = conf->readNumEntry( "maxUndo", m_defaultMaxUndo );
	m_showSplash = conf->readBoolEntry( "showSplash", m_defaultShowSplash );

	conf->setGroup( "LISTVIEW" );
	m_showDocumentation = conf->readBoolEntry( "showDocumentation", m_defaultShowDocumentation );
	m_showCommandLine = conf->readBoolEntry( "showCommandLine", m_defaultShowCommandLine );

	conf->setGroup( "PATHS" );
	m_gentooMode = conf->readBoolEntry( "gentooMode", m_defaultGentooMode );
	m_initPath = conf->readEntry( "initPath", m_defaultInitPath );
	m_rcDefaultPath = conf->readEntry( "rcDefaultPath", m_defaultRcDefaultPath );
	m_iptPath = conf->readEntry( "iptPath", m_defaultIptPath );
	m_modprobePath = conf->readEntry( "modprobePath", m_defaultModprobePath );
	m_currentConfiguration = conf->readPathEntry( "currentConfiguration", m_currentConfiguration );

	conf->setGroup( "INTERFACES" );
	m_interfaces.clear();
	m_interfaces = conf->readListEntry( "interfaces" );
	if ( m_interfaces.empty() )
		m_interfaces << "lo";

	// read general options
	/*   conf->setGroup("General");
	   m_text = conf->readEntry("text", m_defaultText );
	   // read style options
	   conf->setGroup("Style");
	   m_font = conf->readFontEntry("font", &m_defaultFont );
	   m_textColor = conf->readColorEntry("textColor", &m_defaultTextColor );*/
}

void KMFConfiguration::write() const {
	KConfig * conf = kapp->config();
	conf->setGroup( "GENERAL" );
	conf->writeEntry( "firstRun", m_firstRun );
	conf->writeEntry( "maxUndo", m_maxUndo );
	conf->writeEntry( "showSplash", m_showSplash );

	conf->setGroup( "LISTVIEW" );
	conf->writeEntry( "showDocumentation", m_showDocumentation );
	conf->writeEntry( "showCommandLine", m_showCommandLine );

	conf->setGroup( "PATHS" );
	conf->writeEntry( "gentooMode", m_gentooMode );
	conf->writeEntry( "initPath", m_initPath );
	conf->writeEntry( "rcDefaultPath", m_rcDefaultPath );
	conf->writeEntry( "iptPath", m_iptPath );
	conf->writeEntry( "modprobePath", m_modprobePath );
	conf->writePathEntry( "currentConfiguration", m_currentConfiguration );

	conf->setGroup( "INTERFACES" );
	conf->writeEntry( "interfaces", m_interfaces );
	conf->sync();
}

KMFConfiguration& Config() {
	static KMFConfiguration conf;
	return conf;
}
