/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DITEM_H
#define _DITEM_H

#include <qobject.h>

#include "aux.h"

/**
 * This class handles the necessary code for registering
 * and manipulating mindmap items (data and views)
 *
 * @short Mindmap item common class
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DItem
{
    public:
	/// default constructor
	DItem(int);
	/// default destructor
	virtual ~DItem();

	/// returns the unique identification number representing an item
	int Id() const;

	static const int NOITEM=-1;

    private:
	/// internal item id - it cannot be equal to NOITEM (-1)
	int m_id;
};

#endif // _DITEM_H

