/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __container_base_h__
#define __container_base_h__

#include <qwidget.h>

#include "global.h"

class KConfigGroup;
class QPopupMenu;

class BaseContainer : public QWidget
{
    Q_OBJECT

public:
    BaseContainer( QPopupMenu* appletOpMenu, QWidget* parent = 0, const char * name = 0 );
    ~BaseContainer();

    virtual int widthForHeight(int height) const = 0;
    virtual int heightForWidth(int width)  const = 0;

    virtual bool isStretch() const { return false; }

    virtual void about() {}
    virtual void help() {}
    virtual void preferences() {}
    virtual void reportBug() {}

    virtual bool isValid() const { return true; }

    float freeSpace() const { return _fspace; }
    void setFreeSpace(float f) { _fspace = f; }

    QString appletId() const { return _aid; }
    void setAppletId(const QString& s) { _aid = s; }

    virtual int actions() const { return _actions; }

    Direction popupDirection() const { return _dir; }
    Orientation orientation() const { return _orient; }
    Alignment alignment() const { return _alignment; }

    QPopupMenu* opMenu();

    void loadConfiguration( KConfigGroup& );
    void saveConfiguration( KConfigGroup&, bool layoutOnly = false ) const;

    virtual void configure() {}

    QPoint moveOffset() const { return _moveOffset; }

    virtual QString appletType() const = 0;

    /**
     * Reduces a popup menu
     *
     * When a popup menu contains only 1 sub-menu, it makes no sense to
     * show this popup-menu but we better show the sub-menu directly.
     *
     * This function checks whether that is the case and returns either the
     * original menu or the sub-menu when appropriate.
     */
    static QPopupMenu *reduceMenu(QPopupMenu *);

public slots:
    virtual void slotRemoved();
    virtual void slotSetPopupDirection(Direction d) { _dir = d; }
    virtual void slotSetOrientation(Orientation o) { _orient = o; }

    void setAlignment( Alignment a );

signals:
    void removeme(BaseContainer*);
    void moveme(BaseContainer*);
    void requestSave();

    void alignmentChange( Alignment a );

protected:
    virtual void doLoadConfiguration( KConfigGroup& ) {}
    virtual void doSaveConfiguration( KConfigGroup&,
                                      bool /* layoutOnly */ ) const {}

    virtual QPopupMenu* createOpMenu() const = 0;
    QPopupMenu *appletOpMenu() const { return _appletOpMnu; }

    Direction          _dir;
    Orientation        _orient;
    Alignment          _alignment;
    float              _fspace;
    QPoint             _moveOffset;
    QString            _aid;
    int                _actions;

private:
    QPopupMenu        *_opMnu;
    QPopupMenu        *_appletOpMnu;
};

#endif

