/*
 * status.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the declaration of the KBiffStatus
 * widget.
 *
 * $Id: status.h,v 1.5 2002/11/08 02:27:03 gran Exp $
 */
#ifndef KBIFFSTATUS_H 
#define KBIFFSTATUS_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qframe.h>
#include <qlist.h>
#include <qstring.h>

class QListView;
class QPoint;

class KBiffStatusItem : QObject
{
    Q_OBJECT
public:
	KBiffStatusItem(const QString& mailbox, const int num_new);
	KBiffStatusItem(const QString& mailbox, const int num_new,const int num_cur);
	virtual ~KBiffStatusItem();

	QString mailbox() const { return _mailbox; }
	QString newMessages() const { return _newMessages; }
	QString curMessages() const { return _curMessages; }

protected:
	QString _mailbox;
	QString _newMessages;
	QString _curMessages;
};

typedef QList<KBiffStatusItem>         KBiffStatusList;
typedef QListIterator<KBiffStatusItem> KBiffStatusListIterator;

class KBiffStatus : public QFrame
{
	Q_OBJECT
public:
	KBiffStatus(QWidget *parent, const QString& profile, const KBiffStatusList& list);
	virtual ~KBiffStatus();

	void updateListView(const KBiffStatusList& list);
	void popup(const QPoint& pos);

protected:
	QListView *_listView;
};

#endif // KBIFFSTATUS_H
