//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include <stdlib.h>
#include "kbear.h"
#include "resource.h"
#include "kbearapplication.h"

static KCmdLineOptions options[] = {
		{ "+[url] [url]....", I18N_NOOP("The url/urls to open"), 0 },
		{ 0, 0, 0 }
};

int main(int argc, char **argv) {

	KAboutData aboutData( PACKAGE, I18N_NOOP("KBear"), VERSION,
								I18N_NOOP("KBear is a graphical FTP client for KDE."), KAboutData::License_GPL,
								IDS_COPYRIGHT, I18N_NOOP("KBear has ability to connect to multiple hosts simultanously and\n"
								"it has support for multiple protocols.\n"
								"With KBear you can copy/move files/folders not only \n"
								"to or from your local file system, but also between remote hosts.\n"
								"It also provides a flexible site database."),
								IDS_HOMEPAGE, IDS_AUTHOR_EMAIL );
	aboutData.addAuthor( "Björn Sahlström", I18N_NOOP("Maintainer and main developer"), IDS_AUTHOR_EMAIL );
	aboutData.addAuthor( "Frithjof Engel", I18N_NOOP("Developer"), "frithjof_engel@users.sourceforge.net" );
	aboutData.addAuthor( "Peter Svärd", I18N_NOOP("Developer"), IDS_AUTHOR_EMAIL2 );
	aboutData.addCredit ( "Falk Brettschneider", I18N_NOOP("For implementing the excellent library QextMdi"),
									"gigafalk@yahoo.com", "http://www.geocities.com/gigafalk/qextmdi.htm" );
	aboutData.addCredit ( "Carsten Pfeiffer" , I18N_NOOP("For tips and encourage"), "pfeiffer@kde.org" );
	aboutData.addCredit ( "Waldo Bastian", I18N_NOOP("For help and tips"), "bastian@kde.org" );
	aboutData.addCredit ( "Rinse de Vries", I18N_NOOP("Dutch GUI translation") );
	aboutData.addCredit ( "Jan De Luyck", I18N_NOOP("Dutch DOC translation") );
	aboutData.addCredit ( "Fred Lessing", I18N_NOOP("European Portuguese GUI translation") );
	aboutData.addCredit ( "Matij Hausenblas", I18N_NOOP("Czech GUI and DOC translation") );
	aboutData.addCredit ( "CAULIER Gilles", I18N_NOOP("French GUI and DOC translation") );
	aboutData.addCredit ( "Ignacio Verona", I18N_NOOP("Spanish DOC translation") );
	aboutData.addCredit ( "Eugene Doubravsky", I18N_NOOP("Russian GUI translation") );

	KCmdLineArgs::init(argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions(options);
	KBearApplication::addCmdLineOptions();

	if( ! KBearApplication::start() )
		exit( 0 );

	KBearApplication app;

	return app.exec();
}
