/***************************************************************************
                          kbear_slots.cpp  -  description
                             -------------------
    begin                : sn jan 13 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrlist.h>
#include <qhbox.h>
#include <qclipboard.h>
#include <qwhatsthis.h>
#include <qptrlist.h>
#include <qfile.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <ktip.h>
#include <kurldrag.h>
#include <kstatusbar.h>
#include <kapplication.h>
#include <kio/paste.h>
#include <kio/jobclasses.h>
#include <kprotocolinfo.h>
#include <kparts/plugin.h>
#include <kxmlguiclient.h>
#include <kaction.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kmessagebox.h>
#include <kio/slaveconfig.h>
#include <kio/job.h>

#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
#include <stdlib.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbear.h"
#include "resource.h"
#include "kbearmdichildview.h"
#include "kbearquickconnect.h"
#include "kbearsettingsdialog.h"
#include "mixedsettingswidget.h"
#include "windowsettingswidget.h"
#include "firewallsettingswidget.h"
#include "viewsettingswidget.h"
#include "kbearwizard.h"
#include "kbearinfoview.h"
#include "base/connection.h"
#include "base/kbearcopyjob.h"

//-----------------------------------------------
void KBear::slotQuit() {
	statusBar()->message(i18n("Exiting application...") );
	///////////////////////////////////////////////////////////////////
	// exits the Application
//	kapp->quit();
	close();

	statusBar()->message( i18n("Ready.") );
}
//-----------------------------------------------
void KBear::slotQuickConnect() {
	statusBar()->message(i18n("Opening new connection..."));
	KBearQuickConnect quickConnectDlg( this,"QuickConnect");
	quickConnectDlg.setCaption(i18n("QuickConnect"));
	connect( &quickConnectDlg, SIGNAL( openConnection( const Connection& ) ),
                                        this, SLOT( slotCreateClient( const Connection& ) ) );

	quickConnectDlg.exec();
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotDisconnect() {
	statusBar()->message(i18n("Closing connection..."));
	if( activeWindow() ) {
		activeWindow()->close();
	}
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::createGUI( KParts::Part* part ) {
	QextMdiMainFrm::createGUI( part );
	if( ! m_pWindowMenu && part ) {
		m_pWindowMenu = static_cast<QPopupMenu*>(guiFactory()->container("window", this));
	  	connect( m_pWindowMenu, SIGNAL(aboutToShow()), this, SLOT(fillWindowMenu()) );
	}
}
//-----------------------------------------------
void KBear::slotCreateClient( const Connection& connection ) {
	kdDebug()<<"KBear::slotCreateClient url="<<connection.url().prettyURL()<<" pass="<<connection.pass()<<endl;
	Connection c = connection;
	QString name = c.label();
	name = getMdiChildViewCaption( c.label() );
	c.setLabel( name );
	if( c.anonym() ) {
		if( c.pass() == "" )
			c.setPass( email() );
		if( c.user() == "" )
			c.setUser( QString::fromLatin1("anonymous") );
	}

	if( c.protocol() == "kbearftp" ) {
		// Now if it's over ftp we have to set firewall support
		QString oldGroup = kapp->config()->group();
		kapp->config()->setGroup("Firewall");
		unsigned int type = kapp->config()->readUnsignedNumEntry( "Type", FirewallSettingsWidget::NONE );
		QString firewallHost = kapp->config()->readEntry( "Host", QString::null );
		int firewallPort = kapp->config()->readUnsignedNumEntry( "Port", 21 );
		QString firewallUser = kapp->config()->readEntry( "User", QString::null );
		QString firewallPass = decodePassword( kapp->config()->readEntry( "Pass", QString::null ) );
		QString firewallAccount = kapp->config()->readEntry( "Account", QString::null );
		QString firewallMacro = QString::null;
		if( type == FirewallSettingsWidget::TYPE_EIGHT )
			firewallMacro = kapp->config()->readEntry( "Macro", QString::null );
		kapp->config()->setGroup( oldGroup );
		c.setFireWallType( type );
		c.setFireWallHost( firewallHost );
		c.setFireWallPort( firewallPort );
		c.setFireWallUser( firewallUser );
		c.setFireWallPass( firewallPass );
		c.setFireWallAccount( firewallAccount );
		c.setFireWallMacro( firewallMacro );
	}

	KBearMdiChildView* w = new KBearMdiChildView( 0L, c );
	if( c.enableLog() ) {
		m_infoView->addLogPage( w, c.fileSysEncoding() );
	}
	QWhatsThis::add( w, i18n("This Window displays the remote file system.\n"
									"You can use this to transfer files and folders to or "
									"from any other open file system by drag and drop."));

	addWindow( w );

	if( m_autoChildFrameMode && mdiMode() == QextMdi::ChildframeMode )
		setChildFrameMode( m_childFrameMode );
	else if( mdiMode() == QextMdi::ToplevelMode && m_rememberTopLevelChildPos )
		readTopChildPositionFromIndex(m_pWinList->count() - 1 );

	connect( w, SIGNAL( transfer( Transfer* ) ), this, SLOT( slotNewTransfer( Transfer* ) ) );
	// set local path according to the Connection
	m_viewLocal->setPath( c.localPath() );

	// We have to apply chilv view settings to the ne
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_child_toolbar"));
	w->showToolBarUpper( action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_path_toolbar"));
	w->showToolBarLower( action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_statusbar"));
	w->showStatusBarUpper( action->isChecked() );
	action = static_cast<KToggleAction*>(actionCollection()->action("show_child_infobar"));
	w->showStatusBarLower( action->isChecked() );

}
//-----------------------------------------------
void KBear::slotRunTipOfToday(){
	KTipDialog::showTip( this, "kbear/tips", true );
}
//-----------------------------------------------
void KBear::slotOptionsShowToolbar() {
	// this is all very cut and paste code for showing/hiding the toolbar
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action( "options_show_toolbar" ));
	statusBar()->message( action->toolTip() );
	if( action->isChecked())
		toolBar("mainToolBar")->show();
	else
		toolBar("mainToolBar")->hide();
	statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotOptionsShowHelpToolbar() {
	// this is all very cut and paste code for showing/hiding the toolbar
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action( "options_show_help_toolbar" ));
	statusBar()->message( action->toolTip() );
	if( action->isChecked())
		toolBar("helpToolBar")->show();
	else
		toolBar("helpToolBar")->hide();
	statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotOptionsShowStatusbar() {
	// this is all very cut and paste code for showing/hiding the statusbar
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action( KStdAction::stdName(KStdAction::ShowStatusbar) ));
	statusBar()->message( action->toolTip() );
	if(action->isChecked())
		statusBar()->show();
	else
		statusBar()->hide();
	statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slot_toggleTaskBar() {
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action( "show_taskbar" ));
	statusBar()->message( action->toolTip() );
	m_pTaskBar->switchOn( action->isChecked() );
	statusBar()->message(i18n( "Ready." ));
}
//-----------------------------------------------
void KBear::slotOptionsShowViewLocal(){
	if( m_viewLocal == 0L )
		return;
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_local"));
	statusBar()->message( action->toolTip() );
	QPtrListIterator<KParts::Part> it( * m_partManager->parts() );
	bool partRegistered = false;
	for( ; it.current(); ++it ) {
		if( m_viewLocal->part() == it.current() ) {
			partRegistered = true;
			break;
		}
	}
			
	if( action->isChecked() ) {
		if( ! partRegistered )
			m_partManager->addPart( m_viewLocal->part() );
		addWindow( m_viewLocal );
 		m_viewLocal->show();
	}
	else if( ! action->isChecked() ) {
		m_viewLocal->hide();
		if( partRegistered )
			m_partManager->removePart( m_viewLocal->part() );
		removeWindowFromMdi( m_viewLocal );
	}
	setChildFrameMode( m_childFrameMode );
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotOptionsShowTransferWindows(){
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_transferviews"));
	statusBar()->message( action->toolTip() );
	if( action->isChecked() ) {
		m_infoView->showTransferView();
	}
	else {
		m_infoView->hideTransferView();
	}
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotOptionsShowLogWindow(){
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_logview"));
	statusBar()->message( action->toolTip() );
	if( action->isChecked() ) {
		m_infoView->showLogView();
//		makeDockVisible(dockManager->findWidgetParentDock( m_infoView->parentWidget() ));
	}
	else {
		m_infoView->hideLogView();
//		makeDockInvisible(dockManager->findWidgetParentDock( m_infoView->parentWidget() ));
	}
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotOptionsShowChildToolBar(){
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_child_toolbar"));
	statusBar()->message( action->toolTip() );
	KBearMdiChildView* childView;
	for(QextMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()) {
		childView = static_cast<KBearMdiChildView*>(w);		
		childView->showToolBarUpper( action->isChecked() );
	}
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotOptionsShowChildPathToolBar(){
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_child_path_toolbar"));
	statusBar()->message( action->toolTip() );
	KBearMdiChildView* childView;
	for(QextMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()) {
		childView = static_cast<KBearMdiChildView*>(w);		
		childView->showToolBarLower( action->isChecked() );
	}
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotOptionsShowChildStatusBar(){
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_child_statusbar"));
	statusBar()->message( action->toolTip() );
	KBearMdiChildView* childView;
	for(QextMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()) {
		childView = static_cast<KBearMdiChildView*>(w);		
		childView->showStatusBarUpper( action->isChecked() );
	}
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::slotOptionsShowChildInfoBar(){
	KToggleAction* action = static_cast<KToggleAction*>(actionCollection()->action("show_child_infobar"));
	statusBar()->message( action->toolTip() );
	KBearMdiChildView* childView;
	for(QextMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()) {
		childView = static_cast<KBearMdiChildView*>(w);		
		childView->showStatusBarLower( action->isChecked() );
	}
	statusBar()->message(i18n("Ready."));
}
//-----------------------------------------------
void KBear::switchToTabPageMode() {
	QextMdiMainFrm::switchToTabPageMode();
	static_cast<KRadioAction*>(action("mdimode_tabpage"))->setChecked( true );
	enableTileActions( false );
}
//-----------------------------------------------
void KBear::switchToChildframeMode() {
	QextMdiMainFrm::switchToChildframeMode();
	if( m_autoChildFrameMode )
		setChildFrameMode( m_childFrameMode );
	static_cast<KRadioAction*>(action("mdimode_childframe"))->setChecked( true );
	enableTileActions( true );
}
//-----------------------------------------------
void KBear::switchToToplevelMode() {
	QextMdiMainFrm::switchToToplevelMode();
	if(m_rememberTopLevelChildPos)
		readAllTopChildPositions();
	
	m_pDockbaseAreaOfDocumentViews->setDockSite(KDockWidget::DockCorner);
	KDockWidget* pCover = dockManager->findWidgetParentDock( m_infoView );
	pCover->manualDock( m_pDockbaseAreaOfDocumentViews, KDockWidget::DockBottom, 70 );
	if( m_infoView->hidden() )
		makeDockInvisible( pCover );
	else
		makeDockVisible( pCover );

	setMinimumHeight( m_oldMainFrmMinHeight);
	setMaximumHeight( m_oldMainFrmMaxHeight);
	QApplication::sendPostedEvents();	
	if( statusBar()->isHidden() )
		resize( width(), height() + m_infoView->height() );
	else
		resize( width(), height() + m_infoView->height() + statusBar()->height() );

	static_cast<KRadioAction*>(action("mdimode_toplevel"))->setChecked( true );
	enableTileActions( false );
}
//-----------------------------------------------
void KBear::slotOptionsSettings(){
	m_settingsDialog = new KBearSettingsDialog( this, "SettingsDialog" );
	connect( m_settingsDialog, SIGNAL( applyClicked() ), this, SLOT( slotApplySettings() ) );
	if( m_settingsDialog->exec() == QDialog::Accepted ) {
		m_settingsDialog->viewSettings()->saveSettings();
		m_settingsDialog->mixedSettings()->saveSettings();
		m_settingsDialog->windowSettings()->saveSettings();
		m_settingsDialog->firewallSettings()->saveSettings();
		readViewSettings();
		applyViewSettings();
		applyMixedSettings();
		applyWindowSettings();
	}
	delete m_settingsDialog;
}
//-----------------------------------------------
void KBear::slotApplySettings(){
	switch( m_settingsDialog->activePageIndex() ) {
		case 0: //view settings
			m_settingsDialog->viewSettings()->saveSettings();
			readViewSettings();
			applyViewSettings();
			break;
		case 1: //window settings
			m_settingsDialog->windowSettings()->saveSettings();
			applyWindowSettings();
			break;
		case 2: //mixed settings
			m_settingsDialog->mixedSettings()->saveSettings();
			applyMixedSettings();
			break;
		case 3: //firewall settings
			m_settingsDialog->firewallSettings()->saveSettings();
			break;
	}
}
//-----------------------------------------------
void KBear::slotOptionsConfigureKeys() {
	KKeyDialog dlg( true, this );
	dlg.insert( actionCollection() );
	QPtrList<KXMLGUIClient> clients( *childClients() );
	KXMLGUIClient* client;
	for( client = clients.first(); client; client = clients.next() )
		dlg.insert( client->actionCollection() );

	if( dlg.configure( true ) ) {
		kdDebug()<<"KBear::slotOptionsConfigureKeys() new config"<<endl;
		
		for( client = clients.first(); client; client = clients.next() )
			client->reloadXML();

		createGUI( 0L );
		createGUI( m_partManager->activePart() );
	}

/*
	KKeyDialog::configure( actionCollection(), this );
*/
}
//-----------------------------------------------
void KBear::slotOptionsSaveOptions() {
	saveProperties( kapp->config() );
}
//-----------------------------------------------
void KBear::slotOptionsConfigureToolbars() {
	saveMainWindowSettings( kapp->config(), "MainWindow" );
	// use the standard toolbar editor
	KEditToolbar dlg( factory(), this, "ToolBar Config" );
	connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
	dlg.exec();
}
//-----------------------------------------------
void KBear::slotNewToolbarConfig() {
	applyMainWindowSettings( kapp->config(), "MainWindow" );
	m_pWindowMenu = static_cast<QPopupMenu*>(guiFactory()->container("window", this));
	fillWindowMenu();
     // We have to plug the tools actions again
	QPtrList<KParts::Plugin> plugins = KParts::Plugin::pluginObjects( this );
	QPtrListIterator<KParts::Plugin> iter( plugins );
	for( ; iter.current(); ++iter ) {
		if( iter.current()->inherits("KBearToolsPlugin") ) {
			QValueList<KAction*> list = iter.current()->actionCollection()->actions("list");
			QPtrList<KAction> actions;
			for( unsigned int j=0; j < list.count(); j++ )
				actions.append( list[ j ] );				
			iter.current()->plugActionList("tools_list", actions);
			
		}
	}	
}
//-----------------------------------------------
void KBear::fillWindowMenu() {
	bool bTabPageMode = (m_mdiMode == QextMdi::TabPageMode);
	bool bNoViewOpened = m_pWinList->isEmpty();
	action("window_close")->setEnabled( ! bNoViewOpened );
	action("window_close_all")->setEnabled( ! bNoViewOpened );
	action("window_minimize_all")->setEnabled( ! bNoViewOpened && ! bTabPageMode );
	m_dockUndockMenu->setEnabled( ! bNoViewOpened && ! bTabPageMode );
	m_tileMenu->setEnabled( m_mdiMode == QextMdi::ChildframeMode );

	// for all child frame windows: give an ID to every window and connect them in the end with windowMenuItemActivated()
	unplugActionList("window_list");
	QPtrListIterator<KAction> iter(m_dockUndockActions);
	for( ; iter.current(); ++iter) {
		m_dockUndockMenu->remove( iter.current() );
	}

	m_windowListActions.clear();
	m_dockUndockActions.clear();
	int i = 100;
	QextMdiChildView* pView = 0L;
	QPtrListIterator<QextMdiChildView> it(*m_pWinList);


	for( ; it.current(); ++it) {
		pView = it.current();
		if( pView->isToolView())
			continue;

		QString item;
		// set titles of minimized windows in brackets
		if( pView->isMinimized()) {
			item = "(";
			item += pView->caption();
			item += ")";
		}
		else {
			item = " ";
			item += pView->caption();
		}

		// insert the window entry sorted in alphabetical order
		unsigned int indx;
		unsigned int windowItemCount = m_windowListActions.count();
		bool inserted = false;
		QString tmpString;
		KRadioAction* radioAction = new KRadioAction( item, 0, pView, SLOT(slot_clickedInWindowMenu()), this, "window_list_"+item );
         	radioAction->setChecked( pView == m_pCurrentWindow );
		KToggleAction* toggleAction = 0L;
		if( ! bNoViewOpened )
			toggleAction = new KToggleAction( item, 0, pView, SLOT(slot_clickedInDockMenu()), this, "dock_undock_list_"+item );
		for( indx = 0; indx < windowItemCount; indx++) {
			tmpString = m_windowListActions.at( indx )->text();
			if( tmpString.right( tmpString.length()-2) > item.right( item.length()-2)) {
				m_windowListActions.insert( indx, radioAction );
				pView->setWindowMenuID( i );
				if( ! bTabPageMode && ! bNoViewOpened ) {
					m_dockUndockActions.insert( indx, toggleAction );
					toggleAction->setChecked( pView->isAttached() );
				}
				inserted = true;
				indx = windowItemCount+1;  // break the loop
			}
		}
		if( ! inserted ) {  // append it
			m_windowListActions.append( radioAction );
			pView->setWindowMenuID( i );
			if( ! bTabPageMode && ! bNoViewOpened ) {
				m_dockUndockActions.append( toggleAction );
				toggleAction->setChecked( pView->isAttached() );
			}
		}
		i++;
	}
	for( iter.toFirst(); iter.current(); ++iter) {
		m_dockUndockMenu->insert( iter.current() );
	}
	plugActionList("window_list", m_windowListActions );
}
//-----------------------------------------------
void KBear::cascadeWindows() {	
	QextMdiMainFrm::cascadeWindows();
	m_childFrameMode = KBear::Cascade;
	static_cast<KRadioAction*>(action("tile_cascade"))->setChecked( true );
}
//-----------------------------------------------
void KBear::cascadeMaximized() {
	QextMdiMainFrm::cascadeMaximized();
	m_childFrameMode = KBear::CascadeMaximized;
	static_cast<KRadioAction*>(action("tile_cascade_maximized"))->setChecked( true );
}
//-----------------------------------------------
void KBear::expandVertical() {
	QextMdiMainFrm::expandVertical();
	m_childFrameMode = KBear::ExpandVertical;
	static_cast<KRadioAction*>(action("tile_expand_vertical"))->setChecked( true );
}
//-----------------------------------------------
void KBear::expandHorizontal() {
	QextMdiMainFrm::expandHorizontal();
	m_childFrameMode = KBear::ExpandHorizontal;
	static_cast<KRadioAction*>(action("tile_expand_horizontally"))->setChecked( true );
}
//-----------------------------------------------
void KBear::tilePragma() {
	QextMdiMainFrm::tilePragma();
	m_childFrameMode = KBear::PragmasTile;
	static_cast<KRadioAction*>(action("tile_pragma"))->setChecked( true );
}
//-----------------------------------------------
void KBear::tileAnodine() {
	QextMdiMainFrm::tileAnodine();
	m_childFrameMode = KBear::AnodinesTile;
	static_cast<KRadioAction*>(action("tile_anodine"))->setChecked( true );
}
//-----------------------------------------------
void KBear::tileVertically() {
	QextMdiMainFrm::tileVertically();
	m_childFrameMode = KBear::TileVertically;
	static_cast<KRadioAction*>(action("tile_vertically"))->setChecked( true );
}
//-----------------------------------------------
void KBear::slotRunWizard() {
	KBearWizard wizard( this, "KBearWizard" );
	if( wizard.exec() == QDialog::Accepted ) {
		static_cast<ViewSettingsWidget*>( wizard.page( 1 ) )->saveSettings();
		static_cast<WindowSettingsWidget*>( wizard.page( 2 ) )->saveSettings();
		static_cast<MixedSettingsWidget*>( wizard.page( 3 ) )->saveSettings();
		static_cast<FirewallSettingsWidget*>( wizard.page( 4 ) )->saveSettings();
		readViewSettings();
		applyViewSettings();
		applyWindowSettings();
		applyMixedSettings();
	}
}
//-----------------------------------------------
void KBear::slotTransferAdded(){
	if( m_transferQueue.count() == 0 ) // insanity check, should never happend
		return;

	action("transfer_disconnect")->setEnabled( true );
	action("transfer_shutdown")->setEnabled( true );
	/*
	* This slot is called every time a new transfer is added to the transferqueue.
	* Here we have to resolve if the transfer should be started directly or not.
	* This depends on three different things:
	* - m_queueTransfers
	* - transfer->destMetaData()["Queue"]
	* - MAX_ACTIVE_TRANSFERS
	*/
	if( ( m_infoView->numOfTransfers() > MAX_ACTIVE_TRANSFERS )
		|| ( m_queueTransfers && m_infoView->numOfTransfers() > 0 ) )
	{
		kdDebug()<<"KBear::slotTransferAdded() queued globally"<<endl;
		return;
	}
	// first we have to check if user want to queue transfers for this site
	// if so, ignore
	else if( m_transferQueue.head()->destConnection().queue()
			&& ! m_infoView->canStartTransfer( m_transferQueue.head()->destConnection().label(),
														m_transferQueue.head()->sourceConnection().label() ) )
	{
			kdDebug()<<"KBear::slotTransferAdded() queued dest"<<endl;
			return;
	}
	else if( m_transferQueue.head()->sourceConnection().queue()
			&& ! m_infoView->canStartTransfer( m_transferQueue.head()->sourceConnection().label(),
														m_transferQueue.head()->destConnection().label() ) )
	{
			kdDebug()<<"KBear::slotTransferAdded() queued source"<<endl;
			return;
	}
	else
		slotStartNextTransfer();
}
//-----------------------------------------------
void KBear::slotStartTransfer( Transfer* transfer ){
	transfer->start();
	m_transferQueue.remove( transfer );
	m_trayIcon->setToolTip( m_infoView->numOfTransfers(), m_transferQueue.count() );
}
//-----------------------------------------------
void KBear::slotStartNextTransfer(){
	if( m_transferQueue.count() > 0 ) {
		Transfer* transfer = m_transferQueue.dequeue();
		KBearCopyJob* job = transfer->start();
		m_infoView->connectCopyJob( job );
		connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotStartNextTransfer() ) );	
	}
	m_trayIcon->setToolTip( m_infoView->numOfTransfers(), m_transferQueue.count() );
}
//-----------------------------------------------
void KBear::slotNewTransfer( Transfer* transfer ) {
	if( ! transfer ) // insanity check
		return;
	// Here we have to resolve if this is a transfer that we can handle
	//First check the source
	KURL sourceURL = transfer->sourceList().first();
	KURL destURL = transfer->destURL();
	if( ( KProtocolInfo::outputType( sourceURL ) != KProtocolInfo::T_FILESYSTEM )
			|| ! KProtocolInfo::supportsListing( sourceURL )
			|| ! KProtocolInfo::supportsReading( sourceURL )
			|| ! KProtocolInfo::supportsWriting( sourceURL )
			|| ! KProtocolInfo::supportsMakeDir( sourceURL )
			|| ! KProtocolInfo::supportsDeleting( sourceURL ) ) {

		return;
	}
	//then check the destination
	if( ( KProtocolInfo::outputType( destURL ) != KProtocolInfo::T_FILESYSTEM )
			|| ! KProtocolInfo::supportsListing( destURL )
			|| ! KProtocolInfo::supportsReading( destURL )
			|| ! KProtocolInfo::supportsWriting( destURL )
			|| ! KProtocolInfo::supportsMakeDir( destURL )
			|| ! KProtocolInfo::supportsDeleting( destURL ) ) {

		return;
	}
	// Now if it's over ftp we have to set firewall support
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("Firewall");
	unsigned int type = kapp->config()->readUnsignedNumEntry( "Type", FirewallSettingsWidget::NONE );
	QString firewallHost = kapp->config()->readEntry( "Host", QString::null );
	int firewallPort = kapp->config()->readUnsignedNumEntry( "Port", 21 );
	QString firewallUser = kapp->config()->readEntry( "User", QString::null );
	QString firewallPass = kapp->config()->readEntry( "Pass", QString::null );
	QString firewallAccount = kapp->config()->readEntry( "Account", QString::null );
	QString firewallMacro = QString::null;
	if( type == FirewallSettingsWidget::TYPE_EIGHT )
		firewallMacro = kapp->config()->readEntry( "Macro", QString::null );
	kapp->config()->setGroup( oldGroup );

	if( transfer->destConnection().protocol() == "kbearftp" ) {
		transfer->destConnection().setFireWallType( type );
		transfer->destConnection().setFireWallHost( firewallHost );
		transfer->destConnection().setFireWallPort( firewallPort );
		transfer->destConnection().setFireWallUser( firewallUser );
		transfer->destConnection().setFireWallPass( firewallPass );
		transfer->destConnection().setFireWallAccount( firewallAccount );
		transfer->destConnection().setFireWallMacro( firewallMacro );
	}
	if( transfer->sourceConnection().protocol() == "kbearftp" ) {
		transfer->sourceConnection().setFireWallType( type );
		transfer->sourceConnection().setFireWallHost( firewallHost );
		transfer->sourceConnection().setFireWallPort( firewallPort );
		transfer->sourceConnection().setFireWallUser( firewallUser );
		transfer->sourceConnection().setFireWallPass( firewallPass );
		transfer->sourceConnection().setFireWallAccount( firewallAccount );
		transfer->sourceConnection().setFireWallMacro( firewallMacro );
	}
	

	// We add the transfer to the queue
	// this will emit transferAdded() from TransferQueue
	m_infoView->newTransfer( transfer );
	m_transferQueue.enqueue( transfer );	
	m_trayIcon->setToolTip( m_infoView->numOfTransfers(), m_transferQueue.count() );
}
//-----------------------------------------------
void KBear::slotShowSystemTrayIcon( bool show ) {
	if( show )
		m_trayIcon->show();
	else
		m_trayIcon->hide();

}
//-----------------------------------------------
void KBear::slotToggleDisconnect() {
	kdDebug()<<"KBear::slotToggleDisconnect()"<<endl;
	m_disconnectWhenDone = static_cast<KToggleAction*>( action("transfer_disconnect") )->isChecked() ;
}
//-----------------------------------------------
void KBear::slotToggleShutdown() {
	kdDebug()<<"KBear::slotToggleShutdown()"<<endl;
	m_shutdownWhenDone = static_cast<KToggleAction*>( action("transfer_shutdown") )->isChecked() ;
}
//-----------------------------------------------
void KBear::slotTransfersFinished() {
	kdDebug()<<"KBear::slotTransferQueueEmpty()"<<endl;
	action("transfer_disconnect")->setEnabled( false );
	action("transfer_shutdown")->setEnabled( false );
	if( m_disconnectWhenDone ) {
		system( QFile::encodeName( m_disconnectCommand ) );
	}
	if( m_shutdownWhenDone ) {
		if( m_sysShutdownWhenDone ) {
			kapp->requestShutDown( KApplication::ShutdownConfirmNo,
											KApplication::ShutdownTypeHalt,
											KApplication::ShutdownModeSchedule );
		}
		slotQuit();			
	}
	
}
//-----------------------------------------------
