
/*************************************************************************

                          kbear.h  -  description
                             -------------------
    begin                : sn jan 13 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KBEAR_H
#define KBEAR_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtextedit.h>
#include <qptrdict.h>
#include <qdir.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/jobclasses.h>
#include <kparts/mainwindow.h>
#include <kparts/partmanager.h>
#include <ksystemtray.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "qextmdi/qextmdimainfrm.h"
#include "transferqueue.h"
#include "kbearsystemtraydock.h"

/**
*This constant sets up a restriction in number of active transfers.
*All transfers above this number will be autamatically queued
*/
extern const int MAX_ACTIVE_TRANSFERS;

class Connection;
class KToggleAction;
class KBearMdiChildView;
class KBearQuickConnect;
class KBearInfoView;
class ViewSettingsWidget;
class WindowSettingsWidget;
class MixedSettingsWidget;
class KBearSettingsDialog;

/**
	* This Class is the main class of the KBear application. It sets up the main
	* window and provides a menubar, a toolbar, a statusbar a log view and a transfer view.
	* It's also the manager for all child windows as well as transfers etc.
	*
	* @short This class is the main class of the KBear application
	* @see QextMdiMainFrm
	* @author Bjrn Sahlstrm <kbjorn@users.sourceforge.net>
*/


class KBear : public QextMdiMainFrm {
	Q_OBJECT
	friend class KBearWizard;
public:
	/** Default Destructor */
	virtual ~KBear();
	/**
	*  When using ChildFrameModeSettings dialog the enum  is used to set and get the default mode settings
	*/
	enum {
		Cascade,
		CascadeMaximized,
		ExpandVertical,
		ExpandHorizontal,
		AnodinesTile,
		PragmasTile,
		TileVertically,
		NoMode
	};
	/** */
	virtual bool queryExit();
	/** reimplemented for MessageBox on exit */
	virtual bool queryClose();
	/**
	* Returns a popup menu filled according to the MDI view state. You can override this
	* method to insert additional entries there. The popup menu is usually popuped when the user
	* clicks with the right mouse button on a taskbar entry. The default entries are:
	* Undock/Dock, Restore/Maximize/Minimize, Close and an empty sub-popup ( @ref windowPopup() )
	* menu called Operations.
	*/
	virtual QPopupMenu * taskBarPopup(QextMdiChildView *pWnd,bool bIncludeWindowPopup = false);
	/**
	* Reimplemented from @ref QextMdiMainFrm.
	* Catches certain Qt events and processes it here.
	* Currently, here this catches only the @ref QextMdiViewCloseEvent (a QextMDI user event) which is sent
	* from itself in @ref childWindowCloseRequest() right after a @ref QextMdiChildView::closeEvent() .
	* The reason for this event to itself is simple: It just wants to break the function call stack.
	* It breaks the processing if the @ref QextMdiChildView is the LocalFileSystem view
	* with calling @ref slotOptionsShowViewLocal() because we don't want that to close only hide.
	*/
	virtual bool event(QEvent* e);
	/** */
	KParts::PartManager* partManager() { return m_partManager; }
	/** */
	static KBear* self();
	/** */
	static QString email() { return s_email; }
	/** */
	static QString encodedEmail();
	/** */
	static void setEmail( const QString& e ) { s_email = e; }
	/** */
	static QString decodePassword( const QString& pass );
	/** */
	static QString encodePassword( const QString& password );
	/** @returns a reference to the @ref TransferQueue*/
	TransferQueue& transferQueue() { return m_transferQueue; }

public slots:
	/** Docks all view windows (Windows-like) */
	virtual void switchToChildframeMode();
	/** */
	virtual void switchToToplevelMode();
	/** */
	virtual void switchToTabPageMode();
	/**  Update of the window menu contents. */
	virtual void fillWindowMenu();
	/** */
	void slotCreateClient( const Connection& );
	/**  */
	void slotRunTipOfToday();
	/**
	* Switches the QextMdiTaskBar on and off.
	*/
	virtual void slot_toggleTaskBar();
	/** Cascades the windows without resizing them.*/
	virtual void cascadeWindows();
	/** Cascades the windows resizing them to the maximum available size. */
	virtual void cascadeMaximized();
	/** Maximizes only in vertical direction. */
	virtual void expandVertical();
	/** Maximizes only in horizontal direction.*/
	virtual void expandHorizontal();
	/** Tile Pragma */
	virtual void tilePragma();
	/** Tile Anodine */
	virtual void tileAnodine();
	/** Tile Vertically	*/
	virtual void tileVertically();
protected slots:
	/** */
	void createGUI( KParts::Part* part );
	/** */
	void slotQuit();
	/**  */
	void slotOptionsShowToolbar();
	/**  */
	void slotOptionsShowHelpToolbar();
	/**  */
	void slotOptionsShowStatusbar();
	/**  */
	void slotOptionsConfigureKeys();
	/**  */
	void slotOptionsConfigureToolbars();
	/**  */
	void slotOptionsSaveOptions();
	/**  */
	void slotOptionsShowViewLocal();
	/** open the quick connect dialog @see KBearQuickConnect */
    void slotQuickConnect();
    /** asks if really want to diconnect, then closes the actual connection and window */
    void slotDisconnect();
	/**  */
	void slotOptionsShowChildInfoBar();
	/**  */
	void slotOptionsShowChildStatusBar();
	/**  */
	void slotOptionsShowChildPathToolBar();
	/**  */
	void slotOptionsShowChildToolBar();
	/**  */
	void slotRunWizard();
	/**  */
	void slotOptionsShowLogWindow();
	/**  */
	void slotOptionsShowTransferWindows();
	/** */
	void slotOptionsSettings();
protected:
	/**  */
	void readViewSettings();
	/**  */
	void applyViewSettings();
	/**  */
	void applyMixedSettings();
	/**  */
	void applyWindowSettings();
	/**  */
	void setChildFrameMode( unsigned int mode );
	/**  */
	virtual void resizeEvent( QResizeEvent* );
	/**
	* This method is called when it is time for the app to save its
	* properties for session management purposes.
	*/
	virtual void saveProperties(KConfig *);
	/**
	* This method is called when this app is restored.  The KConfig
	* object points to the session management config file that was saved
	* with @ref saveProperties
	*/
	virtual void readProperties(KConfig *);
private slots: // Private slots
	void slotNewTransfer( Transfer* );
	void slotStartTransfer( Transfer* transfer );
	void slotStartNextTransfer();
	void slotTransferAdded();
	void slotApplySettings();
	void slotShowSystemTrayIcon( bool show );
	void slotNewToolbarConfig();
	void slotToggleDisconnect();
	void slotToggleShutdown();
	void slotTransfersFinished();
private: // Private methods
	KBear();

	/** */
	void saveTopChildPositions(KConfig *);
	/** */
	void readTopChildPositionFromIndex(unsigned int);
	/** */
	void readAllTopChildPositions();

	void initViewLocal();
	void initViewInfo();
	void setupActions();
	void setupToolTips();
	void initDefaultEmail();
	/** check if there are any child view with the specified caption.
	* @param caption is the name to look for. Note: if the caption is: "NAME" and there
	* is a child view with the caption "NAME (1)" it will mark this as a name collition.
	@ returns number of name collisions
	*/
	QString getMdiChildViewCaption( const QString& caption );
	/**
	* Returns a reference to the @see KBearMdiChildView belonging to the given name string or 0L.
	*/
	KBearMdiChildView * findMdiChildViewByName(const QString& name);
	void enableTileActions( bool );
private: // Private attributes
	KBearMdiChildView* m_viewLocal;
	KBearInfoView* m_infoView;
	QString m_viewLocalCaption;
	unsigned int m_childFrameMode;
	bool m_autoChildFrameMode;
	static KBear* s_self;
	static QString s_email;
	KParts::PartManager* m_partManager;
	bool m_rememberTopLevelChildPos;
	bool m_queueTransfers;
	bool m_saveRunTimeSettings;
	KBearSettingsDialog* m_settingsDialog;
	TransferQueue m_transferQueue;
	KBearSystemTrayDock* m_trayIcon;
	QPtrList<KAction> m_windowListActions;
	QPtrList<KAction> m_dockUndockActions;
	KActionMenu* m_childViewMenu;
	KActionMenu* m_dockUndockMenu;
	KActionMenu* m_mdiModeMenu;
	KActionMenu* m_tileMenu;
	QString m_disconnectCommand;
	bool m_disconnectWhenDone;
	bool m_shutdownWhenDone;
	bool m_sysShutdownWhenDone;
};
#endif // KBEAR_H
