/***************************************************************************
                          kbearfilecopyjob.h  -  description
                             -------------------
    begin                : tis maj 14 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARFILECOPYJOB_H
#define KBEARFILECOPYJOB_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/jobclasses.h>
//////////////////////////////////////////////////////////////////////
// application specific include files



class KBearFileCopyJob : public KIO::Job {
	Q_OBJECT
public:
	KBearFileCopyJob(  unsigned long dID,unsigned long sID,
					const KURL& src, const KURL& dest, int permissions,
					bool move, bool overwrite, bool resume, bool showProgressInfo);

	~KBearFileCopyJob();
	/**
	* If you know the size of the source file, call this method
	* to inform this job. It will be displayed in the "resume" dialog.
	*/
	void setSourceSize( off_t size );
	/** */
	KURL srcURL() const { return m_src; }
	/** */
	KURL destURL() const { return m_dest; }
    /**
     * Copy a single file.
     *
     * Uses either @ref SlaveBase::copy() if the slave supports that
     * or @ref get() and @ref put() otherwise.
     * @param src Where to get the file.
     * @param dest Where to put the file.
     * @param permissions May be -1. In this case no special permission mode is set.
     * @param overwrite If @p true, any existing file will be overwritten.
     * @param resume
     */
    static KBearFileCopyJob *file_copy( unsigned long dID,unsigned long sID,
						const KURL& src, const KURL& dest, int permissions=-1,
                            bool overwrite=false, bool resume=false,
                            bool showProgressInfo = true);

    /**
     * Move a single file.
     *
     * Use either @ref SlaveBase::rename() if the slave supports that,
     * or @ref copy() and @ref del() otherwise, or eventually get() & put() & del()
     * @param src Where to get the file.
     * @param dest Where to put the file.
     * @param permissions May be -1. In this case no special permission mode is set.
     * @param overwrite If @p true, any existing file will be overwritten.
     * @param resume
     */
    static KBearFileCopyJob* file_move( unsigned long dID,unsigned long sID,
						const KURL& src, const KURL& dest, int permissions=-1,
                            bool overwrite=false, bool resume=false,
                            bool showProgressInfo = true);

signals:
	void sourceInfoMessage( KIO::Job*, const QString& );
	void destInfoMessage( KIO::Job*, const QString&  );
public slots:
	void slotStart();
	void slotData( KIO::Job *, const QByteArray &data);
	void slotDataReq( KIO::Job *, QByteArray &data);

protected slots:
	/**
	* Called whenever a subjob finishes.
	*/
	virtual void slotResult( KIO::Job *job );

	/**
	* Forward signal from subjob
	*/
	void slotProcessedSize( KIO::Job*, KIO::filesize_t size );
	/**
	* Forward signal from subjob
	*/
	void slotTotalSize( KIO::Job*, KIO::filesize_t size );
	/**
	* Forward signal from subjob
	*/
	void slotPercent( KIO::Job*, unsigned long pct );
	/**
	* Forward signal from subjob
	*/
	void slotCanResume( KIO::Job*, KIO::filesize_t offset );
protected:
	void startCopyJob();
	void startCopyJob(const KURL &slave_url);
	void startDataPump();
	void connectSubjob( KIO::SimpleJob * job );

	KURL m_src;
	KURL m_dest;
	int m_permissions;
	bool m_move:1;
	bool m_overwrite:1;
	bool m_resume:1;
	bool m_canResume:1;
	bool m_resumeAnswerSent:1;
	QByteArray m_buffer;
	KIO::SimpleJob *m_moveJob;
	KIO::SimpleJob *m_copyJob;
	KIO::TransferJob *m_getJob;
	KIO::TransferJob *m_putJob;
	KIO::filesize_t m_totalSize;
private:
	class KBearFileCopyJobPrivate;
	KBearFileCopyJobPrivate* d;
};

#endif
