/***************************************************************************
                          kbearchildviewpart.h  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARCHILDVIEWPART_H
#define KBEARCHILDVIEWPART_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qhbox.h>
#include <qlabel.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/part.h>
#include <kconfig.h>
#include <kurldrag.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "connection.h"
#include "kbearpart.h"

class QPopupMenu;
class KToolBar;

/**
  *@author Bjrn Sahlstrm
  */

class KBearChildViewPart : public KBearPart {
   Q_OBJECT
public: 
	/** */	
	KBearChildViewPart( QWidget* parentWidget, const char* widgetName, QObject* parent, const char* name);
	/** */	
	virtual ~KBearChildViewPart();
	/** */
	virtual KURL::List selectedURLs() = 0;
	/** */
	virtual KURL currentDir() = 0;
	/** */
	virtual void readProperties( KConfig* config, const QString& group ) = 0;
	/** */
	virtual Connection connection() const = 0;
	/** */
	virtual void saveProperties( KConfig* config, const QString& group ) = 0;
	/** */
	virtual void showToolBarUpper( bool );
	/** */
	virtual void showToolBarLower( bool );
	/** */
	virtual void showStatusBarUpper( bool );
	/** */
	virtual void showStatusBarLower( bool );
	/** */
	virtual QPopupMenu* popupMenu() { return 0L; }
	/**
	* @returns the embedded viewer part if any or 0L
	*/
	KParts::Part* viewer() { return m_partViewer; }
	/** */
	virtual bool disconnect() = 0;
	/** */
	virtual void openConnection( const Connection& ) = 0;
public slots:
	/** */
	virtual void reload() = 0;
	/** */
	virtual void home() = 0;
	/** */
	virtual void cdUp() = 0;
	/** */
	virtual void back() = 0;
	/** */
	virtual void forward() = 0;
	/** */
	virtual void stop() = 0;
	/**  */
	virtual bool openURL( const KURL& url ) = 0;
signals:
	/** */
	void transfer( KURLDrag* );
	/**  */
	void dropped( QMimeSource*, const QPoint& );
protected:
	/** */
	virtual bool openFile() { return true; }
	/** */
	bool validURL( const KURL& );
protected:
	KToolBar* m_toolBarUpper;
	KToolBar* m_toolBarLower;
	QLabel* m_statusBarUpper;
	QHBox* m_statusBarLower;
	KParts::ReadOnlyPart* m_partViewer;
};

#endif
