
/*
 * playlist.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include "dialogs/vfs.h"
#include "dialogs/dialogs.h"

#include "mixer.h"

#define WRAPPER_BROWSE		1
#define WRAPPER_REARRANGE	2
#define WRAPPER_SHUFFLE		3
#define WRAPPER_PLAYLISTS	4

#define FUNCTION_SWITCHMODE		1
#define FUNCTION_PLAYTRACK		2
#define FUNCTION_PLAYSELECTED	3

class Selection
{
 public:
   /* Initialize datastructures */
   Selection ();
   /* Create a selection with space ntracks of track numbers */
   void CreateTracks (int ntracks);
   /* Destroy the created selection */
   void DestroyTracks ();
   /* Select track */
   void SelectTrack (int trackno);
   /* Select all tracks */
   void SelectAllTracks ();
   /* Deselect track */
   void DeselectTrack (int trackno);
   /* Deselect all tracks */
   void DeselectAllTracks ();
   /* Invert track */
   void InvertTrack (int trackno);
   /* Invert all tracks */
   void InvertAllTracks ();
   /* Check if track is selected */
   bool SelectedTrack (int trackno);
   /* Return the number of selected tracks */
   int NumSelectedTracks ();
 private:
   /* Selected tracks */
   bool *selected;
   /* Number of selected tracks */
   int nselected;
};

/* FIXME: Maybe Selection should inherit VirtualFS and then we make */
/* tracks of type Selection and don't inheret Selection here??? */
class Playlist : public Selection, public MixerDialog
{
 public:
   /* Initialize datastructures */
   Playlist ();
   /* Edit tracks */
   void Edit ();
   /* Browse tracks */
   void Browse ();
   /* Rearrange tracks */
   void Rearrange ();
   /* Shuffle tracks */
   void Shuffle ();
   /* Set wrapper function for specified method */
   void SetWrapper (int wrapper,void (*function)());
   /* Set function for specified method */
   void SetFunction (int functype,void (*function)());
   /* Track listing */
   VirtualFS tracks;
   /* Current track playing, -1 if nothing is currently playing */
   int curtrack;
 private:
   /* Previous directory */
   char lastdir[PATH_MAX];
   /* Boolean value to check if it's the first time that Playlist::Browse() is called */
   bool browsefirst;
   /* Playlist::Browse() wrapper */
   void (*browse_wrapper)();
   /* Playlist::Rearrange() wrapper */
   void (*rearrange_wrapper)();
   /* Playlist::Shuffle() wrapper */
   void (*shuffle_wrapper)();
   /* Playlist::Playlists() wrapper */
   void (*playlists_wrapper)();
   /* Player functions */
   void (*playtrack_function)();
   void (*switchmode_function)();
   void (*playselected_function)();
};

#endif
